/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random.date;

import de.alpharogroup.date.CalculateDateExtensions;
import de.alpharogroup.date.CreateDateExtensions;
import de.alpharogroup.random.enums.RandomAlgorithm;
import de.alpharogroup.random.number.RandomPrimitivesFactory;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public final class RandomDateFactory {
    public static Date dateAfter(Date date, int range, SecureRandom secureRandom) {
        return CalculateDateExtensions.addDays((Date)date, (int)RandomPrimitivesFactory.randomInt(range, RandomAlgorithm.SECURE_RANDOM, secureRandom));
    }

    public static Date dateBefore(Date date, int range, SecureRandom secureRandom) {
        return CalculateDateExtensions.substractDaysFromDate((Date)date, (int)RandomPrimitivesFactory.randomInt(range, RandomAlgorithm.SECURE_RANDOM, secureRandom));
    }

    public static Date randomDate(Date from, SecureRandom secureRandom) {
        Objects.requireNonNull(secureRandom);
        double randDouble = -secureRandom.nextDouble() * (double)from.getTime();
        double randomDouble = (double)from.getTime() - secureRandom.nextDouble();
        double result = randDouble / 99999.0 * (randomDouble / 99999.0);
        return new Date((long)result);
    }

    public static Date randomDate(SecureRandom secureRandom) {
        Date now = CreateDateExtensions.now();
        if (RandomPrimitivesFactory.randomBoolean(secureRandom)) {
            return RandomDateFactory.dateAfter(now, 10000, secureRandom);
        }
        return RandomDateFactory.dateBefore(now, 10000, secureRandom);
    }

    public static Date randomDateBetween(Date start, Date end, SecureRandom secureRandom) {
        Objects.requireNonNull(secureRandom);
        long randomLong = (long)((double)start.getTime() + secureRandom.nextDouble() * (double)(end.getTime() - start.getTime()));
        return new Date(randomLong);
    }

    public static String randomDateBetween(long startDate, long endDate, String format, SecureRandom secureRandom) {
        Objects.requireNonNull(secureRandom);
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        long randomLongBetween = RandomPrimitivesFactory.randomLongBetween(startDate, endDate, secureRandom);
        Date between = new Date(randomLongBetween);
        return sdf.format(between);
    }

    private RandomDateFactory() {
    }
}

