/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random.date;

import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.date.CalculateDateExtensions;
import de.alpharogroup.date.CreateDateExtensions;
import de.alpharogroup.random.SecureRandomFactory;
import de.alpharogroup.random.date.RandomDateFactory;
import de.alpharogroup.random.number.RandomPrimitivesExtensions;
import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;

public final class RandomDateExtensions {
    public static Date dateAfter(Date date) {
        return RandomDateExtensions.dateAfter(date, RandomPrimitivesExtensions.randomInt(10000));
    }

    public static Date dateAfter(Date date, int range) {
        return CalculateDateExtensions.addDays((Date)date, (int)RandomPrimitivesExtensions.randomInt(range));
    }

    public static Date dateBefore(Date date) {
        return RandomDateExtensions.dateBefore(date, 10000);
    }

    public static Date dateBefore(Date date, int range) {
        return RandomDateFactory.dateBefore(date, range, SecureRandomFactory.newSecureRandom());
    }

    public static Date randomBirthday() {
        Date now = CreateDateExtensions.now();
        Date past = RandomDateExtensions.dateBefore(now, 20000);
        Date recentlyPast = RandomDateExtensions.dateBefore(now, 3000);
        return RandomDateExtensions.randomBirthday(recentlyPast, past);
    }

    public static Date randomBirthday(Date from, Date till) {
        return RandomDateExtensions.randomDatebetween(from, till);
    }

    public static Date randomDate() {
        return RandomDateFactory.randomDate(SecureRandomFactory.newSecureRandom());
    }

    public static Date randomDate(Date from) {
        return RandomDateExtensions.randomDate(from, SecureRandomFactory.newSecureRandom());
    }

    public static Date randomDate(Date from, SecureRandom secureRandom) {
        return RandomDateFactory.randomDate(from, secureRandom);
    }

    public static Date randomDatebetween(Date start, Date end) {
        return RandomDateFactory.randomDateBetween(start, end, SecureRandomFactory.newSecureRandom());
    }

    public static String randomDatebetween(long startDate, long endDate) {
        return RandomDateExtensions.randomDatebetween(startDate, endDate, "dd.MM.yyyy HH:mm:ss");
    }

    public static String randomDatebetween(long startDate, long endDate, String format) {
        return RandomDateFactory.randomDateBetween(startDate, endDate, format, SecureRandomFactory.newSecureRandom());
    }

    public static Date randomDateBetween(Date from, int startDays, int endDays) {
        return RandomDateExtensions.dateAfter(from, RandomPrimitivesExtensions.randomIntBetween(startDays, endDays));
    }

    public static LocalDate randomLocalDate() {
        LocalDate now = LocalDate.now();
        LocalDate randomLocalDate = RandomPrimitivesExtensions.randomBoolean() ? now.plusDays(RandomPrimitivesExtensions.randomLongBetween(-999999999L, 999999999L)) : now.minusDays(RandomPrimitivesExtensions.randomLongBetween(-999999999L, 999999999L));
        return randomLocalDate;
    }

    public static LocalDateTime randomLocalDateTime() {
        return LocalDateTime.of(RandomDateExtensions.randomLocalDate(), RandomDateExtensions.randomLocalTime());
    }

    public static LocalTime randomLocalTime() {
        LocalTime now = LocalTime.now();
        LocalTime randomLocalTime = RandomPrimitivesExtensions.randomBoolean() ? now.plusHours(RandomPrimitivesExtensions.randomLong(23L)).plusMinutes(RandomPrimitivesExtensions.randomLong(59L)).plusSeconds(RandomPrimitivesExtensions.randomLong(59L)) : now.minusHours(RandomPrimitivesExtensions.randomLong(23L)).minusMinutes(RandomPrimitivesExtensions.randomLong(59L)).minusSeconds(RandomPrimitivesExtensions.randomLong(59L));
        return randomLocalTime;
    }

    public static ZoneId randomZoneId() {
        List availableZoneIds = ListFactory.newArrayList(ZoneId.getAvailableZoneIds(), (Object[])new String[0]);
        return ZoneId.of((String)availableZoneIds.get(RandomPrimitivesExtensions.randomInt(availableZoneIds.size())));
    }

    private RandomDateExtensions() {
    }
}

