/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random;

import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.random.DefaultSecureRandom;
import de.alpharogroup.random.RandomCharacters;
import de.alpharogroup.random.number.RandomPrimitivesExtensions;
import de.alpharogroup.random.object.RandomStringFactory;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class RandomExtensions {
    public static <T> T getRandomEntry(List<T> list) {
        return list.get(RandomExtensions.getRandomIndex(list));
    }

    public static <K, V> Object getRandomEntry(Map<K, V> map) {
        Object[] entries = map.values().toArray();
        return entries[RandomPrimitivesExtensions.randomInt(entries.length)];
    }

    public static <T extends Enum<?>> T getRandomEnumFromClass(Class<T> clazz) {
        return (T)RandomExtensions.getRandomEnumFromEnumValues((Enum[])((Enum[])clazz.getEnumConstants()));
    }

    public static <T extends Enum<?>> T getRandomEnumFromClassname(String classname) {
        if (classname != null && !classname.isEmpty()) {
            Class enumClass = null;
            try {
                enumClass = ClassExtensions.forName((String)classname);
                return RandomExtensions.getRandomEnumFromClass(enumClass);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public static <T extends Enum<?>> T getRandomEnumFromEnumValues(T[] values) {
        return values[RandomPrimitivesExtensions.randomInt(values.length)];
    }

    public static <T extends Enum<?>> T getRandomEnumFromObject(T obj) {
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            return (T)RandomExtensions.getRandomEnumFromClass(clazz);
        }
        return null;
    }

    public static String getRandomHexString(int numberOfCharacters) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < numberOfCharacters) {
            sb.append(Integer.toHexString(RandomPrimitivesExtensions.randomInt()));
        }
        return sb.toString().substring(0, numberOfCharacters);
    }

    public static <T> int getRandomIndex(Collection<T> list) {
        return RandomPrimitivesExtensions.randomInt(list.size());
    }

    public static <K, V> Object getRandomKey(Map<K, V> map) {
        Set<K> keySet = map.keySet();
        Object[] keys = keySet.toArray();
        return keys[RandomPrimitivesExtensions.randomInt(keys.length)];
    }

    public static byte[] getRandomSalt(int length, Charset charset) {
        return RandomStringFactory.newRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), length).getBytes(charset);
    }

    public static int newRandomPixel() {
        return RandomExtensions.newRandomPixel(RandomPrimitivesExtensions.randomInt(256), RandomPrimitivesExtensions.randomInt(256), RandomPrimitivesExtensions.randomInt(256), RandomPrimitivesExtensions.randomInt(256));
    }

    public static int newRandomPixel(int red, int green, int blue, int alpha) {
        int pixel = alpha << 24 | red << 16 | green << 8 | blue;
        return pixel;
    }

    public static byte[] newSalt() {
        return RandomPrimitivesExtensions.randomByteArray(16);
    }

    public static BigInteger randomSerialNumber() {
        long next = DefaultSecureRandom.get().nextLong();
        if (next < 0L) {
            next *= -1L;
        }
        BigInteger serialNumber = BigInteger.valueOf(next);
        return serialNumber;
    }

    public static String randomToken() {
        BigInteger token = new BigInteger(130, DefaultSecureRandom.get());
        String randomToken = token.toString(32);
        return randomToken;
    }

    public static UUID randomUUID() {
        return UUID.randomUUID();
    }

    private RandomExtensions() {
    }
}

