/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random.number;

import de.alpharogroup.math.MathExtensions;
import de.alpharogroup.random.DefaultSecureRandom;
import de.alpharogroup.random.RandomCharacters;
import de.alpharogroup.random.RandomExtensions;
import de.alpharogroup.random.number.RandomPrimitivesExtensions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public final class RandomNumberExtensions {
    public static BigDecimal getRandomBigDecimal(int afterComma, int beforeComma) {
        String randomFloatString;
        while ((randomFloatString = RandomNumberExtensions.getRandomFloatString(afterComma, beforeComma)).equals(".")) {
        }
        return new BigDecimal(randomFloatString);
    }

    public static String getRandomFloatString(int afterComma, int beforeComma) {
        String nachkommastellen = RandomNumberExtensions.getRandomNumericString(afterComma);
        String vorkommastellen = RandomNumberExtensions.getRandomNumericString(beforeComma);
        String result = nachkommastellen + "." + vorkommastellen;
        return result;
    }

    public static String getRandomNumericString() {
        int maxLength = Math.min(RandomPrimitivesExtensions.randomInt(1000), 1024);
        StringBuilder sb = new StringBuilder(maxLength);
        for (int i = 0; i < maxLength; ++i) {
            int randomInt = RandomPrimitivesExtensions.randomInt();
            if (MathExtensions.isNegative((int)randomInt)) {
                sb.append(randomInt * -1);
                continue;
            }
            sb.append(randomInt);
        }
        return sb.toString();
    }

    public static String getRandomNumericString(int length) {
        String randomNumber = RandomExtensions.getRandomString(RandomCharacters.numbers.getCharacters(), length);
        return randomNumber;
    }

    public static BigInteger randomBigInteger() {
        return new BigInteger(RandomPrimitivesExtensions.randomInt(180), DefaultSecureRandom.get());
    }

    public static BigDecimal randomBigDecimal() {
        BigDecimal bigDecimal = new BigDecimal(RandomPrimitivesExtensions.randomDouble());
        bigDecimal.setScale(RandomPrimitivesExtensions.randomInt(2), RoundingMode.HALF_DOWN);
        return bigDecimal;
    }

    private RandomNumberExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

