/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random.object;

import de.alpharogroup.random.RandomExtensions;
import de.alpharogroup.random.date.RandomDateExtensions;
import de.alpharogroup.random.number.RandomNumberExtensions;
import de.alpharogroup.random.number.RandomPrimitivesExtensions;
import de.alpharogroup.reflection.ReflectionExtensions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import lombok.NonNull;

public final class RandomObjectFactory {
    public static <T> T newRandomObject(@NonNull Class<T> cls, String ... ignoreFieldNames) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        Object instance = ReflectionExtensions.newInstance(cls);
        return (T)RandomObjectFactory.setRandomValues(cls, instance, ignoreFieldNames);
    }

    public static <T> T setRandomValues(@NonNull Class<T> cls, @NonNull T instance, String ... ignoreFieldNames) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        Field[] allDeclaredFields = ReflectionExtensions.getAllDeclaredFields(cls, (String[])new String[0]);
        List<String> toIgnoreFields = Arrays.asList(ignoreFieldNames);
        for (Field field : allDeclaredFields) {
            if (Modifier.isFinal(field.getModifiers()) || toIgnoreFields.contains(field.getName())) continue;
            Object value = RandomObjectFactory.newRandomValue(field);
            ReflectionExtensions.setFieldValue(instance, (Field)field, (Object)value);
        }
        return instance;
    }

    public static Object newRandomValue(Field field) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        Class<?> type = field.getType();
        if (type.isEnum()) {
            Object randomEnum = RandomExtensions.getRandomEnumFromClassname(type.getCanonicalName());
            return randomEnum;
        }
        if (type.equals(Void.TYPE) || type.equals(Void.class)) {
            return null;
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return RandomPrimitivesExtensions.randomByte();
        }
        if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            return Character.valueOf(RandomPrimitivesExtensions.randomChar());
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return RandomPrimitivesExtensions.randomShort();
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return RandomPrimitivesExtensions.randomBoolean();
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return RandomPrimitivesExtensions.randomInt();
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return RandomPrimitivesExtensions.randomLong();
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return RandomPrimitivesExtensions.randomDouble();
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf(RandomPrimitivesExtensions.randomFloat());
        }
        if (type.equals(String.class)) {
            return RandomExtensions.getRandomString();
        }
        if (type.equals(BigInteger.class)) {
            return RandomNumberExtensions.randomBigInteger();
        }
        if (type.equals(BigDecimal.class)) {
            return RandomNumberExtensions.randomBigDecimal();
        }
        if (type.equals(Date.class)) {
            return RandomDateExtensions.randomDate();
        }
        if (type.equals(LocalDateTime.class)) {
            return RandomDateExtensions.randomLocalDateTime();
        }
        if (type.equals(LocalDate.class)) {
            return RandomDateExtensions.randomLocalDate();
        }
        if (type.equals(LocalTime.class)) {
            return RandomDateExtensions.randomLocalTime();
        }
        return RandomObjectFactory.newRandomObject(type, new String[0]);
    }

    private RandomObjectFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

