/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random.number;

import de.alpharogroup.random.DefaultSecureRandom;
import de.alpharogroup.random.number.RandomNumberExtensions;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Random;

public final class RandomPrimitivesExtensions {
    public static boolean randomBoolean() {
        return RandomPrimitivesExtensions.randomInt(2) == 0;
    }

    public static byte randomByte() {
        return (byte)RandomPrimitivesExtensions.randomInt(255);
    }

    public static byte[] randomByteArray(int length) {
        byte[] randomByteArray = new byte[length];
        for (int i = 0; i < length; ++i) {
            randomByteArray[i] = RandomPrimitivesExtensions.randomByte();
        }
        return randomByteArray;
    }

    public static char randomChar() {
        if (DefaultSecureRandom.get().nextBoolean()) {
            return (char)(DefaultSecureRandom.get().nextInt(26) + 65);
        }
        return (char)DefaultSecureRandom.get().nextInt(10);
    }

    public static short randomShort() {
        if (DefaultSecureRandom.get().nextBoolean()) {
            return (short)(DefaultSecureRandom.get().nextInt(65536) - 32768);
        }
        return (short)DefaultSecureRandom.get().nextInt(32768);
    }

    public static char randomChar(String string) {
        return string.charAt(RandomPrimitivesExtensions.randomInt(string.length()));
    }

    public static long randomLong() {
        return RandomPrimitivesExtensions.randomLong(new Random(System.currentTimeMillis()).nextInt());
    }

    public static long randomLong(long range) {
        if (DefaultSecureRandom.get() != null) {
            return (long)(DefaultSecureRandom.get().nextDouble() * (double)range);
        }
        return (long)(Math.random() * (double)range);
    }

    public static long randomLongBetween(long start, long end) {
        return start + RandomPrimitivesExtensions.randomLong(end - start);
    }

    public static float randomFloat() {
        if (DefaultSecureRandom.get() != null) {
            return RandomPrimitivesExtensions.randomFloat(DefaultSecureRandom.get().nextFloat());
        }
        return RandomPrimitivesExtensions.randomFloat(new Random(System.currentTimeMillis()).nextFloat());
    }

    public static double randomDouble(double range) {
        if (DefaultSecureRandom.get() != null) {
            return DefaultSecureRandom.get().nextDouble() * range;
        }
        return Math.random() * range;
    }

    public static double randomDouble() {
        return RandomPrimitivesExtensions.randomDouble(Double.MAX_VALUE);
    }

    public static double randomDoubleBetween(double start, double end) {
        return start + RandomPrimitivesExtensions.randomDouble(end - start);
    }

    public static double randomDoubleBetween(double start, double end, String pattern) throws ParseException {
        DecimalFormat formatter = new DecimalFormat(pattern);
        String rd = formatter.format(RandomPrimitivesExtensions.randomDoubleBetween(start, end));
        Number randomDouble = formatter.parse(rd);
        return randomDouble.doubleValue();
    }

    public static float randomFloat(float range) {
        if (DefaultSecureRandom.get() != null) {
            return (float)(DefaultSecureRandom.get().nextDouble() * (double)range);
        }
        return (float)(Math.random() * (double)range);
    }

    public static float randomFloat(int afterComma, int beforeComma) {
        return Float.parseFloat(RandomPrimitivesExtensions.getRandomFloatString(afterComma, beforeComma));
    }

    private static String getRandomFloatString(int afterComma, int beforeComma) {
        String nachkommastellen = RandomNumberExtensions.getRandomNumericString(afterComma);
        String vorkommastellen = RandomNumberExtensions.getRandomNumericString(beforeComma);
        String result = nachkommastellen + "." + vorkommastellen;
        return result;
    }

    public static float randomFloatBetween(float start, float end) {
        return start + RandomPrimitivesExtensions.randomFloat(end - start);
    }

    public static float randomFloatBetween(float start, float end, String pattern) throws ParseException {
        DecimalFormat formatter = new DecimalFormat(pattern);
        String rf = formatter.format(RandomPrimitivesExtensions.randomFloatBetween(start, end));
        Number randomFloat = formatter.parse(rf);
        return randomFloat.floatValue();
    }

    public static int randomInt() {
        if (DefaultSecureRandom.get() != null) {
            return RandomPrimitivesExtensions.randomInt(DefaultSecureRandom.get().nextInt());
        }
        return RandomPrimitivesExtensions.randomInt(new Random(System.currentTimeMillis()).nextInt());
    }

    public static int randomInt(int range) {
        if (DefaultSecureRandom.get() != null) {
            return (int)(DefaultSecureRandom.get().nextDouble() * (double)range);
        }
        return (int)(Math.random() * (double)range);
    }

    public static int randomIntBetween(int start, int end) {
        return RandomPrimitivesExtensions.randomIntBetween(start, end, true, false);
    }

    public static int randomIntBetween(int start, int end, boolean includeMin, boolean includeMax) {
        int randomIntBetween = start + RandomPrimitivesExtensions.randomInt(end - start);
        if (includeMin && includeMax) {
            randomIntBetween = start + RandomPrimitivesExtensions.randomInt(end - (start + 1));
        }
        if (includeMin && !includeMax) {
            randomIntBetween = start + RandomPrimitivesExtensions.randomInt(end - start);
        }
        if (!includeMin && includeMax) {
            randomIntBetween = start + 1 + RandomPrimitivesExtensions.randomInt(end - (start + 1));
        }
        if (!includeMin && !includeMax) {
            randomIntBetween = start + 1 + RandomPrimitivesExtensions.randomInt(end - start);
        }
        return randomIntBetween;
    }

    public static int getRandomIntBetween(int minVolume, int maxVolume) {
        return minVolume + Math.abs(DefaultSecureRandom.get().nextInt()) % maxVolume;
    }

    private RandomPrimitivesExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

