/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random.date;

import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.date.CalculateDateExtensions;
import de.alpharogroup.random.SecureRandomFactory;
import de.alpharogroup.random.number.RandomPrimitivesExtensions;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public final class RandomDateExtensions {
    private static SecureRandom secureRandom = SecureRandomFactory.newSecureRandom();

    public static Date dateAfter(Date date) {
        return RandomDateExtensions.dateAfter(date, RandomPrimitivesExtensions.randomInt(10000));
    }

    public static ZoneId randomZoneId() {
        List availableZoneIds = ListFactory.newArrayList(ZoneId.getAvailableZoneIds(), (Object[])new String[0]);
        return ZoneId.of((String)availableZoneIds.get(RandomPrimitivesExtensions.randomInt(availableZoneIds.size())));
    }

    public static LocalDateTime randomLocalDateTime() {
        return LocalDateTime.of(RandomDateExtensions.randomLocalDate(), RandomDateExtensions.randomLocalTime());
    }

    public static LocalTime randomLocalTime() {
        LocalTime now = LocalTime.now();
        LocalTime randomLocalTime = RandomPrimitivesExtensions.randomBoolean() ? now.plusHours(RandomPrimitivesExtensions.randomLong(23L)).plusMinutes(RandomPrimitivesExtensions.randomLong(59L)).plusSeconds(RandomPrimitivesExtensions.randomLong(59L)) : now.minusHours(RandomPrimitivesExtensions.randomLong(23L)).minusMinutes(RandomPrimitivesExtensions.randomLong(59L)).minusSeconds(RandomPrimitivesExtensions.randomLong(59L));
        return randomLocalTime;
    }

    public static LocalDate randomLocalDate() {
        LocalDate now = LocalDate.now();
        LocalDate randomLocalDate = RandomPrimitivesExtensions.randomBoolean() ? now.plusDays(RandomPrimitivesExtensions.randomLong()) : now.minusDays(RandomPrimitivesExtensions.randomLong());
        return randomLocalDate;
    }

    public static Date dateAfter(Date date, int range) {
        return CalculateDateExtensions.addDays((Date)date, (int)RandomPrimitivesExtensions.randomInt(range));
    }

    public static Date dateBefore(Date date) {
        return RandomDateExtensions.dateBefore(date, 10000);
    }

    public static Date dateBefore(Date date, int range) {
        return CalculateDateExtensions.substractDaysFromDate((Date)date, (int)range);
    }

    public static Timestamp getTimestamp() {
        return RandomDateExtensions.getTimestamp(new Date());
    }

    public static Timestamp getTimestamp(Date date) {
        GregorianCalendar gregCal = new GregorianCalendar();
        gregCal.setTime(date);
        gregCal.set(11, 0);
        gregCal.set(12, 0);
        gregCal.set(13, 0);
        gregCal.set(14, 0);
        return new Timestamp(gregCal.getTime().getTime());
    }

    public static Date randomBirthday() {
        Date now = new Date(System.currentTimeMillis());
        Date past = RandomDateExtensions.dateBefore(now, 20000);
        Date recentlyPast = RandomDateExtensions.dateBefore(now, 3000);
        Date randomBirthday = RandomDateExtensions.randomBirthday(recentlyPast, past);
        return randomBirthday;
    }

    public static Date randomBirthday(Date from, Date till) {
        Date randomBirthday = RandomDateExtensions.randomDatebetween(from, till);
        return randomBirthday;
    }

    public static Date randomDate(Date from) {
        double randDouble = -secureRandom.nextDouble() * (double)from.getTime();
        double randomDouble = (double)from.getTime() - secureRandom.nextDouble();
        double result = randDouble / 99999.0 * (randomDouble / 99999.0);
        return new Date((long)result);
    }

    public static Date randomDate() {
        Date now = new Date(System.currentTimeMillis());
        if (RandomPrimitivesExtensions.randomBoolean()) {
            return RandomDateExtensions.dateAfter(now, RandomPrimitivesExtensions.randomInt(10000));
        }
        return RandomDateExtensions.dateBefore(now, RandomPrimitivesExtensions.randomInt(10000));
    }

    public static Date randomDatebetween(Date start, Date end) {
        long randomLong = (long)((double)start.getTime() + secureRandom.nextDouble() * (double)(end.getTime() - start.getTime()));
        return new Date(randomLong);
    }

    public static String randomDatebetween(long startDate, long endDate) {
        return RandomDateExtensions.randomDatebetween(startDate, endDate, "dd.MM.yyyy HH:mm:ss");
    }

    public static String randomDatebetween(long startDate, long endDate, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        long randomLongBetween = RandomPrimitivesExtensions.randomLongBetween(startDate, endDate);
        Date between = new Date(randomLongBetween);
        return sdf.format(between);
    }

    public static Date randomDateBetween(Date from, int startDays, int endDays) {
        return RandomDateExtensions.dateAfter(from, RandomPrimitivesExtensions.randomIntBetween(startDays, endDays));
    }

    private RandomDateExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

