/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random;

import de.alpharogroup.random.RandomCharacters;
import de.alpharogroup.random.RandomExtensions;
import de.alpharogroup.reflection.ReflectionExtensions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Optional;
import lombok.NonNull;

public final class RandomObjectsExtensions {
    public static String getInfomailFromWebsite(String url) {
        int startIndex = url.indexOf("www.");
        StringBuilder email = new StringBuilder();
        if (0 < startIndex) {
            String emailprefix = "info";
            email.append("info");
            email.append("@");
            email.append(url.substring(startIndex + 4, url.length()));
        } else if (0 == startIndex) {
            String emailprefix = "info";
            email.append("info");
            email.append("@");
            email.append(url.substring(startIndex + 2, url.length()));
        } else {
            throw new IllegalArgumentException(url);
        }
        return email.toString();
    }

    public static String getRandomEmail() {
        StringBuffer email = new StringBuffer();
        String emailprefix = RandomExtensions.getRandomString(RandomCharacters.lowcaseWithNumbers.getCharacters(), RandomExtensions.randomInt(20) + 1);
        String domain = RandomExtensions.getRandomString(RandomCharacters.lowcase.getCharacters(), RandomExtensions.randomInt(12) + 1);
        String topDomain = RandomExtensions.getRandomString(RandomCharacters.lowcase.getCharacters(), 2);
        email.append(emailprefix);
        email.append("@");
        email.append(domain);
        email.append(".");
        email.append(topDomain);
        return email.toString();
    }

    public static String getRandomFaxnumber(String phonenumber) {
        StringBuffer sb = new StringBuffer();
        String randomFax = phonenumber.substring(0, phonenumber.length() - 2);
        sb.append(randomFax);
        String phoneExtension = phonenumber.substring(phonenumber.length() - 2, phonenumber.length());
        Integer phEx = new Integer(phoneExtension);
        int pe = phEx + 1;
        sb.append(pe);
        return sb.toString();
    }

    public static String getRandomMobilnumber() {
        StringBuffer randomPhonenumber = new StringBuffer();
        randomPhonenumber.append("0");
        randomPhonenumber.append(RandomExtensions.getRandomNumericString(3));
        randomPhonenumber.append("/");
        randomPhonenumber.append(RandomExtensions.getRandomNumericString(7));
        return randomPhonenumber.toString();
    }

    public static String getRandomPassword(int length) {
        String password = RandomExtensions.getRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), length);
        return password;
    }

    public static String getRandomPassword(Optional<Integer> length) {
        if (length.isPresent()) {
            String password = RandomExtensions.getRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), (int)length.get());
            return password;
        }
        return RandomExtensions.getRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), 8);
    }

    public static String getRandomPhonenumber() {
        StringBuffer randomPhonenumber = new StringBuffer();
        randomPhonenumber.append("0");
        randomPhonenumber.append(RandomExtensions.getRandomNumericString(4));
        randomPhonenumber.append("/");
        randomPhonenumber.append(RandomExtensions.getRandomNumericString(7));
        return randomPhonenumber.toString();
    }

    public static String getRandomWebsite() {
        StringBuffer website = new StringBuffer();
        String websitePrefix = "http://www";
        String domain = RandomExtensions.getRandomString(RandomCharacters.lowcase.getCharacters(), RandomExtensions.randomInt(12) + 1);
        String topDomain = RandomExtensions.getRandomString(RandomCharacters.lowcase.getCharacters(), 2);
        website.append("http://www");
        website.append(".");
        website.append(domain);
        website.append(".");
        website.append(topDomain);
        return website.toString();
    }

    public static String newRandomId() {
        StringBuffer sb = new StringBuffer();
        sb.append(RandomExtensions.getRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), 2));
        sb.append(".");
        sb.append(RandomExtensions.getRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), 4));
        sb.append(".");
        sb.append(RandomExtensions.getRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), 2));
        sb.append(".");
        sb.append(System.currentTimeMillis());
        sb.append(".");
        sb.append(RandomExtensions.getRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), 2));
        return sb.toString();
    }

    public static String newRandomName(char[] donatedChars) {
        StringBuffer sb = new StringBuffer(donatedChars.length);
        ArrayList<Character> dc = new ArrayList<Character>(donatedChars.length);
        for (char donatedChar : donatedChars) {
            dc.add(Character.valueOf(donatedChar));
        }
        boolean fullList = true;
        while (fullList) {
            int randomIndex = RandomExtensions.randomInt(dc.size());
            Character c = (Character)dc.get(randomIndex);
            sb.append(c);
            dc.remove(randomIndex);
            if (!dc.isEmpty()) continue;
            fullList = false;
        }
        return sb.toString();
    }

    @Deprecated
    public static <T> T newRandomObject(@NonNull Class<T> cls) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        Field[] allDeclaredFields;
        if (cls == null) {
            throw new NullPointerException("cls is marked @NonNull but is null");
        }
        Object instance = ReflectionExtensions.newInstance(cls);
        for (Field field : allDeclaredFields = ReflectionExtensions.getAllDeclaredFields(cls, (String[])new String[0])) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            Object value = RandomObjectsExtensions.newRandomValue(field);
            ReflectionExtensions.setFieldValue((Object)instance, (String)field.getName(), (Object)value);
        }
        return (T)instance;
    }

    @Deprecated
    public static Object newRandomValue(Field field) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        Class<?> type = field.getType();
        if (type.isEnum()) {
            Object randomEnum = RandomExtensions.getRandomEnumFromClassname(type.getCanonicalName());
            return randomEnum;
        }
        if (type.equals(Void.TYPE) || type.equals(Void.class)) {
            return null;
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return RandomExtensions.randomByte();
        }
        if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            return Character.valueOf(RandomExtensions.randomChar());
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return RandomExtensions.randomShort();
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return RandomExtensions.randomBoolean();
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return RandomExtensions.randomInt();
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return RandomExtensions.randomLong();
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return RandomExtensions.randomDouble();
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf(RandomExtensions.randomFloat());
        }
        if (type.equals(String.class)) {
            return RandomExtensions.getRandomString();
        }
        if (type.equals(BigInteger.class)) {
            return RandomExtensions.randomSerialNumber();
        }
        return RandomObjectsExtensions.newRandomObject(type);
    }

    private RandomObjectsExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

