/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random;

import de.alpharogroup.random.RandomExtensions;
import de.alpharogroup.reflection.ReflectionExtensions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public final class RandomObjectFactory {
    public static <T> T newRandomObject(@NonNull Class<T> cls, String ... ignoreFieldNames) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        if (cls == null) {
            throw new NullPointerException("cls is marked @NonNull but is null");
        }
        Object instance = ReflectionExtensions.newInstance(cls);
        Field[] allDeclaredFields = ReflectionExtensions.getAllDeclaredFields(cls, (String[])new String[0]);
        List<String> toIgnoreFields = Arrays.asList(ignoreFieldNames);
        for (Field field : allDeclaredFields) {
            if (Modifier.isFinal(field.getModifiers()) || toIgnoreFields.contains(field.getName())) continue;
            Object value = RandomObjectFactory.newRandomValue(field);
            ReflectionExtensions.setFieldValue((Object)instance, (String)field.getName(), (Object)value);
        }
        return (T)instance;
    }

    public static Object newRandomValue(Field field) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        Class<?> type = field.getType();
        if (type.isEnum()) {
            Object randomEnum = RandomExtensions.getRandomEnumFromClassname(type.getCanonicalName());
            return randomEnum;
        }
        if (type.equals(Void.TYPE) || type.equals(Void.class)) {
            return null;
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return RandomExtensions.randomByte();
        }
        if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            return Character.valueOf(RandomExtensions.randomChar());
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return RandomExtensions.randomShort();
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return RandomExtensions.randomBoolean();
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return RandomExtensions.randomInt();
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return RandomExtensions.randomLong();
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return RandomExtensions.randomDouble();
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf(RandomExtensions.randomFloat());
        }
        if (type.equals(String.class)) {
            return RandomExtensions.getRandomString();
        }
        if (type.equals(BigInteger.class)) {
            return RandomExtensions.randomBigInteger();
        }
        if (type.equals(BigDecimal.class)) {
            return RandomExtensions.randomBigDecimal();
        }
        return RandomObjectFactory.newRandomObject(type, new String[0]);
    }

    private RandomObjectFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

