/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random;

import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.math.MathExtensions;
import de.alpharogroup.random.RandomCharacters;
import de.alpharogroup.random.SecureRandomBean;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public final class RandomExtensions {
    private static SecureRandom secureRandom = SecureRandomBean.builder().buildQuietly();

    public static long randomLong() {
        return RandomExtensions.randomLong(new Random(System.currentTimeMillis()).nextInt());
    }

    public static long randomLong(long range) {
        if (secureRandom != null) {
            return (long)(secureRandom.nextDouble() * (double)range);
        }
        return (long)(Math.random() * (double)range);
    }

    public static long randomLongBetween(long start, long end) {
        return start + RandomExtensions.randomLong(end - start);
    }

    public static float randomFloat() {
        if (secureRandom != null) {
            return RandomExtensions.randomFloat(secureRandom.nextFloat());
        }
        return RandomExtensions.randomFloat(new Random(System.currentTimeMillis()).nextFloat());
    }

    public static SecureRandom getSecureRandom() {
        return secureRandom;
    }

    public static int newRandomPixel() {
        return RandomExtensions.newRandomPixel(RandomExtensions.randomInt(256), RandomExtensions.randomInt(256), RandomExtensions.randomInt(256), RandomExtensions.randomInt(256));
    }

    public static int newRandomPixel(int red, int green, int blue, int alpha) {
        int pixel = alpha << 24 | red << 16 | green << 8 | blue;
        return pixel;
    }

    public static BigDecimal getRandomBigDecimal(int afterComma, int beforeComma) {
        String randomFloatString;
        while ((randomFloatString = RandomExtensions.getRandomFloatString(afterComma, beforeComma)).equals(".")) {
        }
        return new BigDecimal(randomFloatString);
    }

    public static Byte getRandomByte() {
        return RandomExtensions.randomByte();
    }

    public static Byte[] getRandomByteArray(int length) {
        Byte[] randomByteArray = new Byte[length];
        byte[] randomByteBox = new byte[1];
        for (int i = 0; i < length; ++i) {
            if (RandomExtensions.randomBoolean()) {
                randomByteArray[i] = RandomExtensions.getRandomByte();
                continue;
            }
            if (secureRandom != null) {
                secureRandom.nextBytes(randomByteBox);
                randomByteArray[i] = randomByteBox[0];
                continue;
            }
            randomByteArray[i] = RandomExtensions.getRandomByte();
        }
        return randomByteArray;
    }

    public static <T> T getRandomEntry(List<T> list) {
        return list.get(RandomExtensions.getRandomIndex(list));
    }

    public static <K, V> Object getRandomEntry(Map<K, V> map) {
        Object[] entries = map.values().toArray();
        return entries[RandomExtensions.randomInt(entries.length)];
    }

    public static <T extends Enum<?>> T getRandomEnum(Class<T> clazz) {
        return (T)RandomExtensions.getRandomEnum((Enum[])clazz.getEnumConstants());
    }

    public static <T extends Enum<?>> T getRandomEnum(String classname) {
        if (classname != null && !classname.isEmpty()) {
            Class enumClass = null;
            try {
                enumClass = ClassExtensions.forName((String)classname);
                return (T)RandomExtensions.getRandomEnum(enumClass);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public static <T extends Enum<?>> T getRandomEnum(T obj) {
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            return (T)RandomExtensions.getRandomEnum(clazz);
        }
        return null;
    }

    public static <T extends Enum<?>> T getRandomEnum(T[] values) {
        return values[RandomExtensions.randomInt(values.length)];
    }

    public static Float getRandomFloat(int afterComma, int beforeComma) {
        return Float.valueOf(RandomExtensions.randomFloat(afterComma, beforeComma));
    }

    private static String getRandomFloatString(int afterComma, int beforeComma) {
        String nachkommastellen = RandomExtensions.getRandomNumericString(afterComma);
        String vorkommastellen = RandomExtensions.getRandomNumericString(beforeComma);
        String result = nachkommastellen + "." + vorkommastellen;
        return result;
    }

    public static <T> int getRandomIndex(Collection<T> list) {
        return RandomExtensions.randomInt(list.size());
    }

    public static <K, V> Object getRandomKey(Map<K, V> map) {
        Set<K> keySet = map.keySet();
        Object[] keys = keySet.toArray();
        return keys[RandomExtensions.randomInt(keys.length)];
    }

    public static String getRandomNumericString() {
        int maxLength = Math.min(RandomExtensions.randomInt(1000), 1024);
        StringBuilder sb = new StringBuilder(maxLength);
        for (int i = 0; i < maxLength; ++i) {
            int randomInt = RandomExtensions.randomInt();
            if (MathExtensions.isNegative((int)randomInt)) {
                sb.append(randomInt * -1);
                continue;
            }
            sb.append(randomInt);
        }
        return sb.toString();
    }

    public static String getRandomNumericString(int length) {
        String randomNumber = RandomExtensions.getRandomString(RandomCharacters.numbers.getCharacters(), length);
        return randomNumber;
    }

    public static String getRandomString(int length) {
        int maxLength = Math.min(length, 1024);
        StringBuilder sb = new StringBuilder(maxLength);
        for (int i = 0; i < maxLength; ++i) {
            sb.append(RandomExtensions.randomChar());
        }
        return sb.toString();
    }

    public static String getRandomHexString(int numberOfCharacters) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < numberOfCharacters) {
            sb.append(Integer.toHexString(RandomExtensions.randomInt()));
        }
        return sb.toString().substring(0, numberOfCharacters);
    }

    public static String getRandomString(String chars, int length) {
        StringBuffer ergebnis = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            ergebnis.append(RandomExtensions.randomChar(chars));
        }
        return ergebnis.toString();
    }

    public static String getRandomString(String[] array) {
        return array[RandomExtensions.randomInt(array.length)];
    }

    public static boolean randomBoolean() {
        return RandomExtensions.randomInt(2) == 0;
    }

    public static byte randomByte() {
        return (byte)RandomExtensions.randomInt(255);
    }

    public static byte[] randomByteArray(int length) {
        byte[] randomByteArray = new byte[length];
        for (int i = 0; i < length; ++i) {
            randomByteArray[i] = RandomExtensions.randomByte();
        }
        return randomByteArray;
    }

    public static char randomChar() {
        if (secureRandom.nextBoolean()) {
            return (char)(secureRandom.nextInt(26) + 65);
        }
        return (char)secureRandom.nextInt(10);
    }

    public static char randomChar(String string) {
        return string.charAt(RandomExtensions.randomInt(string.length()));
    }

    public static double randomDouble(double range) {
        if (secureRandom != null) {
            return secureRandom.nextDouble() * range;
        }
        return Math.random() * range;
    }

    public static double randomDoubleBetween(double start, double end) {
        return start + RandomExtensions.randomDouble(end - start);
    }

    public static double randomDoubleBetween(double start, double end, String pattern) throws ParseException {
        DecimalFormat formatter = new DecimalFormat(pattern);
        String rd = formatter.format(RandomExtensions.randomDoubleBetween(start, end));
        Number randomDouble = formatter.parse(rd);
        return randomDouble.doubleValue();
    }

    public static float randomFloat(float range) {
        if (secureRandom != null) {
            return (float)(secureRandom.nextDouble() * (double)range);
        }
        return (float)(Math.random() * (double)range);
    }

    public static float randomFloat(int afterComma, int beforeComma) {
        return Float.parseFloat(RandomExtensions.getRandomFloatString(afterComma, beforeComma));
    }

    public static float randomFloatBetween(float start, float end) {
        return start + RandomExtensions.randomFloat(end - start);
    }

    public static float randomFloatBetween(float start, float end, String pattern) throws ParseException {
        DecimalFormat formatter = new DecimalFormat(pattern);
        String rf = formatter.format(RandomExtensions.randomFloatBetween(start, end));
        Number randomFloat = formatter.parse(rf);
        return randomFloat.floatValue();
    }

    public static int randomInt() {
        if (secureRandom != null) {
            return RandomExtensions.randomInt(secureRandom.nextInt());
        }
        return RandomExtensions.randomInt(new Random(System.currentTimeMillis()).nextInt());
    }

    public static int randomInt(int range) {
        if (secureRandom != null) {
            return (int)(secureRandom.nextDouble() * (double)range);
        }
        return (int)(Math.random() * (double)range);
    }

    public static int randomIntBetween(int start, int end) {
        return RandomExtensions.randomIntBetween(start, end, true, false);
    }

    public static int randomIntBetween(int start, int end, boolean includeMin, boolean includeMax) {
        int randomIntBetween = start + RandomExtensions.randomInt(end - start);
        if (includeMin && includeMax) {
            randomIntBetween = start + RandomExtensions.randomInt(end - (start + 1));
        }
        if (includeMin && !includeMax) {
            randomIntBetween = start + RandomExtensions.randomInt(end - start);
        }
        if (!includeMin && includeMax) {
            randomIntBetween = start + 1 + RandomExtensions.randomInt(end - (start + 1));
        }
        if (!includeMin && !includeMax) {
            randomIntBetween = start + 1 + RandomExtensions.randomInt(end - start);
        }
        return randomIntBetween;
    }

    public static String randomToken() {
        BigInteger token = new BigInteger(130, RandomExtensions.getSecureRandom());
        String randomToken = token.toString(32);
        return randomToken;
    }

    public static BigInteger randomSerialNumber() {
        long next = RandomExtensions.getSecureRandom().nextLong();
        if (next < 0L) {
            next *= -1L;
        }
        BigInteger serialNumber = BigInteger.valueOf(next);
        return serialNumber;
    }

    public static byte[] getRandomPrimitiveByteArray(int length) {
        byte[] randomByteArray = new byte[length];
        byte[] randomByteBox = new byte[1];
        for (int i = 0; i < length; ++i) {
            if (RandomExtensions.randomBoolean()) {
                randomByteArray[i] = RandomExtensions.getRandomByte();
                continue;
            }
            secureRandom.nextBytes(randomByteBox);
            randomByteArray[i] = randomByteBox[0];
        }
        return randomByteArray;
    }

    public static byte[] newSalt() {
        return RandomExtensions.getRandomPrimitiveByteArray(16);
    }

    public static byte[] getRandomSalt(int length, Charset charset) {
        return RandomExtensions.getRandomString(RandomCharacters.lowcaseWithUppercaseAndNumbers.getCharacters(), length).getBytes(charset);
    }

    private RandomExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

