/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.export.excel.poi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;

public final class ExportExcelExtensions {
    public static List<String[][]> exportWorkbook(File excelSheet) throws IOException, FileNotFoundException {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(excelSheet));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        int numberOfSheets = wb.getNumberOfSheets();
        ArrayList<String[][]> sheetList = new ArrayList<String[][]>();
        for (int sheetNumber = 0; sheetNumber < numberOfSheets; ++sheetNumber) {
            HSSFSheet sheet = null;
            sheet = wb.getSheetAt(sheetNumber);
            int rows = sheet.getLastRowNum();
            int columns = sheet.getRow(0).getLastCellNum();
            String[][] excelSheetInTDArray = null;
            excelSheetInTDArray = new String[rows + 1][columns];
            for (int i = 0; i <= rows; ++i) {
                HSSFRow row = sheet.getRow(i);
                if (null == row) continue;
                for (int j = 0; j < columns; ++j) {
                    excelSheetInTDArray[i][j] = ExportExcelExtensions.getCellValueAsString((Cell)row.getCell(j));
                }
            }
            sheetList.add(excelSheetInTDArray);
        }
        wb.close();
        return sheetList;
    }

    public static String getCellValueAsString(Cell cell) {
        String result = null;
        if (null == cell) {
            return "";
        }
        CellType cellType = cell.getCellType();
        if (CellType.BLANK.equals((Object)cellType)) {
            result = "";
        } else if (CellType.BOOLEAN.equals((Object)cellType)) {
            result = Boolean.toString(cell.getBooleanCellValue());
        } else if (CellType.ERROR.equals((Object)cellType)) {
            result = "";
        } else if (CellType.FORMULA.equals((Object)cellType)) {
            result = cell.getCellFormula();
        } else if (CellType.NUMERIC.equals((Object)cellType)) {
            result = Double.toString(cell.getNumericCellValue());
        } else if (CellType.STRING.equals((Object)cellType)) {
            result = cell.getRichStringCellValue().getString();
        }
        return result;
    }

    public static List<List<List<String>>> exportWorkbookAsStringList(File excelSheet) throws IOException, FileNotFoundException {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(excelSheet));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        int numberOfSheets = wb.getNumberOfSheets();
        ArrayList<List<List<String>>> sl = new ArrayList<List<List<String>>>();
        for (int sheetNumber = 0; sheetNumber < numberOfSheets; ++sheetNumber) {
            HSSFSheet sheet = null;
            sheet = wb.getSheetAt(sheetNumber);
            int rows = sheet.getLastRowNum();
            int columns = sheet.getRow(0).getLastCellNum();
            ArrayList excelSheetList = new ArrayList();
            for (int i = 0; i <= rows; ++i) {
                HSSFRow row = sheet.getRow(i);
                if (null == row) continue;
                ArrayList<String> reihe = new ArrayList<String>();
                for (int j = 0; j < columns; ++j) {
                    reihe.add(ExportExcelExtensions.getCellValueAsString((Cell)row.getCell(j)));
                }
                excelSheetList.add(reihe);
            }
            sl.add(excelSheetList);
        }
        wb.close();
        return sl;
    }

    public static HSSFWorkbook replaceNullCellsIntoEmptyCells(File excelSheet) throws IOException, FileNotFoundException {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(excelSheet));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        int numberOfSheets = wb.getNumberOfSheets();
        for (int sheetNumber = 0; sheetNumber < numberOfSheets; ++sheetNumber) {
            HSSFSheet sheet = null;
            sheet = wb.getSheetAt(sheetNumber);
            int rows = sheet.getLastRowNum();
            int columns = sheet.getRow(0).getLastCellNum();
            for (int i = 0; i <= rows; ++i) {
                HSSFRow row = sheet.getRow(i);
                if (null == row) continue;
                for (int j = 0; j < columns; ++j) {
                    HSSFCell cell = row.getCell(j);
                    if (cell != null) continue;
                    cell = row.createCell(j, CellType.BLANK);
                }
            }
        }
        return wb;
    }

    private ExportExcelExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

