package phone.data.management.system.service;

import hbm.service.jpa.AbstractBusinessService;

import java.util.List;

import javax.persistence.Query;

import de.alpharogroup.collections.ListExtensions;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import phone.data.management.system.daos.SlotScoreDao;
import phone.data.management.system.model.SlotScore;
import phone.data.management.system.service.api.SlotScoreService;
import phone.data.management.system.service.util.HqlStringCreator;


@Transactional
@Service("slotScoreService")
public class SlotScoreBusinessService extends AbstractBusinessService<SlotScore, Integer, SlotScoreDao> implements SlotScoreService  {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Autowired
	public void setProfileRatingsDao(SlotScoreDao slotScoreDao) {
		setDao(slotScoreDao);
	}
	
	public SlotScore find(String phoneNumber){
		final List<SlotScore> slotScores = find(phoneNumber, null);
		return ListExtensions.getFirst(slotScores);		
	}
	
	@SuppressWarnings("unchecked")
	public List<SlotScore> find(String phoneNumber, Integer score) {
		String hqlString = HqlStringCreator.forSlotScore(phoneNumber, score);
		final Query query = getQuery(hqlString);
		if(phoneNumber != null && !phoneNumber.isEmpty()){
			query.setParameter("phoneNumber", phoneNumber);
		}
		if(score != null){
			query.setParameter("score", score);
		}
		final List<SlotScore> images = query.getResultList();
		return images;
	}
}
