package phone.data.management.system.factories;

import java.io.Serializable;

import phone.data.management.system.model.SlotScore;


public class PhoneDataManagementFactory implements Serializable
{
	/**
	 * The serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;
	/** The Constant instance. */
	private static final PhoneDataManagementFactory instance = new PhoneDataManagementFactory();

	/**
	 * Gets the single instance of DomainObjectFactory.
	 * 
	 * @return single instance of DomainObjectFactory
	 */
	public static PhoneDataManagementFactory getInstance() {
		return instance;
	}
	
	protected SlotScore getSlotScore(Integer id, String phoneNumber,Integer score) {
		SlotScore slotScore = new SlotScore();
		slotScore.setId(id);
		slotScore.setPhoneNumber(phoneNumber);
		slotScore.setScore(score);
		return slotScore;
	}
	
	public SlotScore getSlotScore(String phoneNumber,Integer score) {
		return getSlotScore(null, phoneNumber, score);
	}

}
