/*
 * Decompiled with CFR 0.152.
 */
package phone.data.management.system.service;

import de.alpharogroup.collections.ListExtensions;
import hbm.dao.jpa.EntityManagerDao;
import hbm.service.jpa.AbstractBusinessService;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import phone.data.management.system.daos.SlotScoreDao;
import phone.data.management.system.model.SlotScore;
import phone.data.management.system.service.api.SlotScoreService;
import phone.data.management.system.service.util.HqlStringCreator;

@Transactional
@Service(value="slotScoreService")
public class SlotScoreBusinessService
extends AbstractBusinessService<SlotScore, Integer, SlotScoreDao>
implements SlotScoreService {
    private static final long serialVersionUID = 1L;

    @Autowired
    public void setProfileRatingsDao(SlotScoreDao slotScoreDao) {
        this.setDao((EntityManagerDao)slotScoreDao);
    }

    @Override
    public SlotScore find(String phoneNumber) {
        List<SlotScore> slotScores = this.find(phoneNumber, null);
        return (SlotScore)ListExtensions.getFirst(slotScores);
    }

    @Override
    public List<SlotScore> find(String phoneNumber, Integer score) {
        String hqlString = HqlStringCreator.forSlotScore(phoneNumber, score);
        Query query = this.getQuery(hqlString);
        if (phoneNumber != null && !phoneNumber.isEmpty()) {
            query.setParameter("phoneNumber", (Object)phoneNumber);
        }
        if (score != null) {
            query.setParameter("score", (Object)score);
        }
        List images = query.getResultList();
        return images;
    }
}

