/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.phone.data.management.system;

import de.alpharogroup.file.delete.DeleteFileExtensions;
import de.alpharogroup.file.search.PathFinder;
import de.alpharogroup.jdbc.ConnectionsExtensions;
import de.alpharogroup.jetty9.runner.Jetty9Runner;
import de.alpharogroup.jetty9.runner.config.Jetty9RunConfiguration;
import de.alpharogroup.jetty9.runner.config.ServletContextHandlerConfiguration;
import de.alpharogroup.jetty9.runner.config.ServletHolderConfiguration;
import de.alpharogroup.jetty9.runner.factories.ServletContextHandlerFactory;
import de.alpharogroup.log.LoggerExtensions;
import de.alpharogroup.resourcebundle.properties.PropertiesExtensions;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.EventListener;
import java.util.Properties;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.springframework.web.context.ContextLoaderListener;

public class ApplicationJettyRunner {
    protected static boolean existsPostgreSQLDatabase() throws IOException, ClassNotFoundException, SQLException {
        Properties databaseProperties = PropertiesExtensions.loadProperties((String)"jdbc.properties");
        String hostname = databaseProperties.getProperty("jdbc.host");
        String databaseName = databaseProperties.getProperty("jdbc.db.name");
        String databaseUser = databaseProperties.getProperty("jdbc.user");
        String databasePassword = databaseProperties.getProperty("jdbc.password");
        boolean dbExists = ConnectionsExtensions.existsPostgreSQLDatabase((String)hostname, (String)databaseName, (String)databaseUser, (String)databasePassword);
        return dbExists;
    }

    protected static String getProjectName() throws IOException {
        Properties projectProperties = PropertiesExtensions.loadProperties((String)"project.properties");
        String projectName = projectProperties.getProperty("artifactId");
        return projectName;
    }

    public static void main(String[] args) throws Exception {
        int sessionTimeout = 1800;
        String projectname = ApplicationJettyRunner.getProjectName();
        File projectDirectory = PathFinder.getProjectDirectory();
        File webapp = PathFinder.getRelativePath((File)projectDirectory, (String[])new String[]{projectname, "src", "main", "webapp"});
        String filterPath = "/*";
        File logfile = new File(projectDirectory, "application.log");
        if (logfile.exists()) {
            try {
                DeleteFileExtensions.delete((File)logfile);
            }
            catch (IOException e) {
                Logger.getRootLogger().error((Object)"logfile could not deleted.", (Throwable)e);
            }
        }
        LoggerExtensions.addFileAppender((Logger)Logger.getRootLogger(), (FileAppender)LoggerExtensions.newFileAppender((String)logfile.getAbsolutePath()));
        ServletContextHandler servletContextHandler = ServletContextHandlerFactory.getNewServletContextHandler((ServletContextHandlerConfiguration)ServletContextHandlerConfiguration.builder().servletHolderConfiguration(ServletHolderConfiguration.builder().servletClass(CXFServlet.class).pathSpec("/*").build()).contextPath("/").webapp(webapp).maxInactiveInterval(1800).filterPath("/*").initParameter("contextConfigLocation", "classpath:application-context.xml").build());
        servletContextHandler.addEventListener((EventListener)new ContextLoaderListener());
        Jetty9RunConfiguration configuration = Jetty9RunConfiguration.builder().servletContextHandler(servletContextHandler).httpPort(11080).httpsPort(11443).build();
        Server server = new Server();
        Jetty9Runner.runServletContextHandler((Server)server, (Jetty9RunConfiguration)configuration);
    }
}

