/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.phone.data.management.system.rest;

import de.alpharogroup.domain.DomainObject;
import de.alpharogroup.phone.data.management.system.domain.SlotScore;
import de.alpharogroup.phone.data.management.system.rest.api.SlotScoresResource;
import de.alpharogroup.phone.data.management.system.service.api.SlotScoreService;
import de.alpharogroup.service.rs.AbstractRestfulResource;
import java.util.List;
import javax.ws.rs.core.Response;

public class SlotScoresRestResource
extends AbstractRestfulResource<Integer, SlotScore, SlotScoreService>
implements SlotScoresResource {
    private static final String UPDATE_SCORE_ACTION = "UpdateScore";
    private static final String GET_SCORE_ACTION = "GetScore";

    @Override
    public Response find(String phoneNumber) {
        SlotScoreService domainService = (SlotScoreService)this.getDomainService();
        SlotScore slotScore = domainService.find(phoneNumber);
        return Response.ok((Object)slotScore).build();
    }

    @Override
    public List<SlotScore> find(String phoneNumber, Integer score) {
        SlotScoreService domainService = (SlotScoreService)this.getDomainService();
        List slotScores = domainService.find(phoneNumber, score);
        return slotScores;
    }

    @Override
    public String getScore(String action, String phoneNumber, String score) {
        SlotScoreService domainService = (SlotScoreService)this.getDomainService();
        SlotScore slotScore = domainService.find(phoneNumber);
        if (GET_SCORE_ACTION.equals(action)) {
            if (slotScore == null) {
                slotScore = SlotScore.builder().phoneNumber(phoneNumber).score(Integer.valueOf(1000)).build();
                slotScore = (SlotScore)domainService.create((DomainObject)slotScore);
            }
        } else if (UPDATE_SCORE_ACTION.equals(action)) {
            if (slotScore != null) {
                try {
                    Integer credits = Integer.valueOf(score);
                    slotScore.setScore(credits);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            } else {
                slotScore = SlotScore.builder().phoneNumber(phoneNumber).score(Integer.valueOf(1000)).build();
            }
            slotScore = (SlotScore)domainService.create((DomainObject)slotScore);
        }
        return Integer.toString(slotScore.getScore());
    }
}

