/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.phone.data.management.system.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.phone.data.management.system.daos.SlotScoresDao;
import de.alpharogroup.phone.data.management.system.entities.SlotScores;
import de.alpharogroup.phone.data.management.system.service.api.SlotScoresService;
import de.alpharogroup.phone.data.management.system.service.util.HqlStringCreator;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="slotScoresService")
public class SlotScoresBusinessService
extends AbstractBusinessService<SlotScores, Integer, SlotScoresDao>
implements SlotScoresService {
    private static final long serialVersionUID = 1L;

    @Override
    @Transactional
    public SlotScores find(String phoneNumber) {
        List<SlotScores> slotScores = this.find(phoneNumber, null);
        return (SlotScores)ListExtensions.getFirst(slotScores);
    }

    @Override
    public List<SlotScores> find(String phoneNumber, Integer score) {
        String hqlString = HqlStringCreator.forSlotScore(phoneNumber, score);
        Query query = this.getQuery(hqlString);
        if (phoneNumber != null && !phoneNumber.isEmpty()) {
            query.setParameter("phoneNumber", (Object)phoneNumber);
        }
        if (score != null) {
            query.setParameter("score", (Object)score);
        }
        List images = query.getResultList();
        return images;
    }

    @Autowired
    public void setProfileRatingsDao(SlotScoresDao slotScoreDao) {
        this.setDao((EntityManagerDao)slotScoreDao);
    }
}

