/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.postgres.usertype;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.ParameterizedType;
import org.postgresql.util.PGobject;

public class PGEnumUserType
implements EnhancedUserType,
ParameterizedType {
    private static final Logger log = Logger.getLogger(PGEnumUserType.class.getName());
    public static final PGEnumUserType INSTANCE = new PGEnumUserType();
    private Class<Enum> enumClass;

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Enum)this.deepCopy(value);
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return Objects.equals(x, y);
    }

    public Object fromXMLString(String xmlValue) {
        return Enum.valueOf(this.enumClass, xmlValue);
    }

    public int hashCode(Object object) throws HibernateException {
        return Objects.hashCode(object);
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        String columnName = names[0];
        Object columnValue = rs.getObject(columnName);
        Object[] params = new Object[]{columnName, columnValue};
        log.log(Level.FINE, "Result set column {0} value is {1}", params);
        if (rs.wasNull()) {
            return null;
        }
        if (columnValue instanceof PGobject) {
            PGobject pg = (PGobject)columnValue;
            return Enum.valueOf(this.enumClass, pg.getValue());
        }
        if (columnValue != null && this.enumClass != null) {
            String enumValueName = columnValue.toString().trim();
            return Enum.valueOf(this.enumClass, enumValueName);
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            log.log(Level.FINE, "Binding null to parameter {0} ", index);
            st.setNull(index, 1111);
        } else {
            Object[] params = new Object[]{value, index};
            log.log(Level.FINE, "Result set column {0} value is {1}", params);
            st.setObject(index, value, 1111);
        }
    }

    public String objectToSQLString(Object value) {
        return '\'' + ((Enum)value).name() + '\'';
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }

    public Class returnedClass() {
        return this.enumClass;
    }

    public void setParameterValues(Properties parameters) {
        String enumClassName = parameters.getProperty("enumClassName");
        try {
            this.enumClass = Class.forName(enumClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Enum class not found", (Throwable)cnfe);
        }
    }

    public int[] sqlTypes() {
        return new int[]{12};
    }

    public String toXMLString(Object value) {
        return ((Enum)value).name();
    }
}

