/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.design.pattern.observer.exception;

import de.alpharogroup.design.pattern.observer.exception.ExceptionEvent;
import de.alpharogroup.design.pattern.observer.exception.ExceptionListener;
import java.util.ArrayList;
import java.util.List;

public class ExceptionObservers {
    private static ExceptionObservers instance = null;
    protected List<ExceptionListener> exceptionListeners = new ArrayList<ExceptionListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ExceptionObservers getInstance() {
        Class<ExceptionObservers> clazz = ExceptionObservers.class;
        synchronized (ExceptionObservers.class) {
            if (instance == null) {
                instance = new ExceptionObservers();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ExceptionObservers() {
    }

    public void addExceptionListener(ExceptionListener listener) {
        this.exceptionListeners.add(listener);
    }

    void fireExceptionEvent(ExceptionEvent event) {
        int listenerSize = this.exceptionListeners.size();
        for (int i = 0; i < listenerSize; ++i) {
            ExceptionListener lis = this.exceptionListeners.get(i);
            lis.onException(event);
        }
    }

    public void removeExceptionListener(ExceptionListener listener) {
        this.exceptionListeners.remove(listener);
    }
}

