/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.design.pattern.observer.chat.listener;

import de.alpharogroup.design.pattern.observer.chat.listener.MessageListener;
import de.alpharogroup.design.pattern.observer.chat.listener.MessageSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MessageSubject<T>
implements MessageSource<T> {
    private T source;
    private final List<MessageListener<T>> messageListeners = new ArrayList<MessageListener<T>>();

    public MessageSubject() {
    }

    public MessageSubject(T source) {
        this.source = source;
    }

    @Override
    public synchronized void add(MessageListener<T> messageListener) {
        this.messageListeners.add(messageListener);
    }

    @Override
    public synchronized void addAll(Collection<MessageListener<T>> messageListeners) {
        this.messageListeners.addAll(messageListeners);
    }

    private synchronized void fireMessage() {
        for (MessageListener<T> messageListener : this.messageListeners) {
            messageListener.onMessage(this.source);
        }
    }

    @Override
    public synchronized void fireMessage(T source) {
        this.source = source;
        this.fireMessage();
    }

    @Override
    public synchronized void remove(MessageListener<T> messageListener) {
        this.messageListeners.remove(messageListener);
    }

    @Override
    public synchronized void removeAll(Collection<MessageListener<T>> messageListeners) {
        this.messageListeners.removeAll(messageListeners);
    }
}

