/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.design.pattern.observer.chat;

import de.alpharogroup.design.pattern.observer.api.ActionCommand;
import de.alpharogroup.design.pattern.observer.api.Observer;
import de.alpharogroup.design.pattern.observer.chat.ChatRoom;
import de.alpharogroup.design.pattern.observer.chat.IUser;
import de.alpharogroup.design.pattern.observer.chat.Message;
import java.io.Serializable;

public abstract class ChatRoomUser<M extends Message<?>>
implements Observer<M>,
ActionCommand,
Serializable {
    private static final long serialVersionUID = 1L;
    protected ChatRoom<M> subject;
    private M observable;
    private final IUser<?> user;

    public ChatRoomUser(ChatRoom<M> room, IUser<?> user) {
        this.subject = room;
        this.observable = this.subject.getObservable();
        this.user = user;
        this.subject.add(this);
    }

    public synchronized M getObservable() {
        return this.observable;
    }

    public IUser<?> getUser() {
        return this.user;
    }

    public void send(M message) {
        this.subject.setObservable(message);
    }

    @Override
    public synchronized void update(M observable) {
        this.observable = observable;
        this.execute();
    }
}

