/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.design.pattern.observer.chat;

import de.alpharogroup.design.pattern.observer.AbstractSubject;
import de.alpharogroup.design.pattern.observer.api.Subject;
import de.alpharogroup.design.pattern.observer.chat.ChatRoomUser;
import de.alpharogroup.design.pattern.observer.chat.IUser;
import de.alpharogroup.design.pattern.observer.chat.Message;
import de.alpharogroup.design.pattern.observer.chat.Room;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ChatRoom<M extends Message<?>>
extends AbstractSubject<M, ChatRoomUser<M>>
implements Subject<M, ChatRoomUser<M>>,
Room<M>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<ChatRoomUser<M>> observers = new ArrayList<ChatRoomUser<M>>();
    private final List<M> messageHistory = new ArrayList<M>();
    private M observable;
    private final String name;

    public ChatRoom(M observable, String name) {
        this.observable = observable;
        this.name = name;
    }

    public ChatRoom(String name) {
        this.name = name;
    }

    @Override
    public synchronized void add(ChatRoomUser<M> observer) {
        this.observers.add(observer);
    }

    @Override
    public void addAll(Collection<ChatRoomUser<M>> observers) {
        for (ChatRoomUser<M> chatUser : observers) {
            this.add(chatUser);
        }
    }

    @Override
    public List<IUser<?>> getChatRoomUsers() {
        ArrayList chatRoomUsers = new ArrayList();
        for (ChatRoomUser<M> chatUser : this.observers) {
            chatRoomUsers.add(chatUser.getUser());
        }
        return chatRoomUsers;
    }

    @Override
    public List<M> getMessageHistory() {
        return this.messageHistory;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public synchronized M getObservable() {
        return this.observable;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public synchronized void remove(ChatRoomUser<M> observer) {
        int index = this.observers.indexOf(observer);
        if (0 <= index) {
            this.observers.remove(observer);
        }
    }

    @Override
    public void removeAll(Collection<ChatRoomUser<M>> observers) {
        for (ChatRoomUser<M> chatUser : observers) {
            this.remove(chatUser);
        }
    }

    @Override
    public synchronized void setObservable(M observable) {
        this.observable = observable;
        this.messageHistory.add(observable);
        this.updateObservers();
    }

    public int size() {
        return this.observers.size();
    }

    @Override
    public synchronized void updateObservers() {
        for (ChatRoomUser<M> observer : this.observers) {
            observer.update(this.observable);
        }
    }
}

