/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model.util;

import de.alpharogroup.model.IDetachable;
import de.alpharogroup.model.IObjectClassAwareModel;
import java.io.Serializable;
import java.util.Objects;

public abstract class GenericBaseModel<T>
implements IObjectClassAwareModel<T> {
    private static final long serialVersionUID = 1L;
    private T object;

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public void setObject(T object) {
        if (!(object instanceof Serializable)) {
            object = this.createSerializableVersionOf(object);
        }
        this.object = object;
    }

    protected abstract T createSerializableVersionOf(T var1);

    @Override
    public void detach() {
        if (this.object instanceof IDetachable) {
            ((IDetachable)this.object).detach();
        }
    }

    @Override
    public Class<T> getObjectClass() {
        return this.object != null ? this.object.getClass() : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Model:classname=[");
        sb.append(this.getClass().getName()).append(']');
        sb.append(":object=[").append(this.object).append(']');
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.object);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericBaseModel)) {
            return false;
        }
        GenericBaseModel that = (GenericBaseModel)obj;
        return Objects.equals(this.object, that.object);
    }
}

