/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model;

import de.alpharogroup.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoadableDetachableModel<T>
implements IModel<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(LoadableDetachableModel.class);
    private transient boolean attached = false;
    private transient T transientModelObject;

    public LoadableDetachableModel() {
    }

    public LoadableDetachableModel(T object) {
        this.transientModelObject = object;
        this.attached = true;
    }

    @Override
    public void detach() {
        if (this.attached) {
            try {
                this.onDetach();
            }
            finally {
                this.attached = false;
                this.transientModelObject = null;
            }
        }
    }

    @Override
    public final T getObject() {
        if (!this.attached) {
            this.attached = true;
            this.transientModelObject = this.load();
            this.onAttach();
        }
        return this.transientModelObject;
    }

    public final boolean isAttached() {
        return this.attached;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(":attached=").append(this.attached).append(":tempModelObject=[").append(this.transientModelObject).append("]");
        return sb.toString();
    }

    protected abstract T load();

    protected void onAttach() {
    }

    protected void onDetach() {
    }

    @Override
    public void setObject(T object) {
        this.attached = true;
        this.transientModelObject = object;
    }
}

