/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model;

import de.alpharogroup.model.IDetachable;
import de.alpharogroup.model.IModel;
import de.alpharogroup.model.IObjectClassAwareModel;
import de.alpharogroup.model.util.MapModel;
import de.alpharogroup.model.util.WildcardCollectionModel;
import de.alpharogroup.model.util.WildcardListModel;
import de.alpharogroup.model.util.WildcardSetModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenericModel<T>
implements IObjectClassAwareModel<T> {
    private static final long serialVersionUID = 1L;
    private T object;

    public GenericModel() {
    }

    public GenericModel(T object) {
        this.setObject(object);
    }

    public static <C> IModel<List<C>> ofList(List<C> list) {
        return new WildcardListModel<C>(list);
    }

    public static <K, V> IModel<Map<K, V>> ofMap(Map<K, V> map) {
        return new MapModel<K, V>(map);
    }

    public static <C> IModel<Set<C>> ofSet(Set<C> set) {
        return new WildcardSetModel<C>(set);
    }

    public static <C> IModel<Collection<C>> of(Collection<C> collection) {
        return new WildcardCollectionModel<C>(collection);
    }

    public static <T> GenericModel<T> of(T object) {
        return new GenericModel<T>(object);
    }

    public static <T> GenericModel<T> of() {
        return new GenericModel<T>();
    }

    @Override
    public void detach() {
        if (this.object instanceof IDetachable) {
            ((IDetachable)this.object).detach();
        }
    }

    @Override
    public Class<T> getObjectClass() {
        return this.object != null ? this.object.getClass() : null;
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public void setObject(T object) {
        this.object = object;
    }

    public String toString() {
        return "GenericModel(object=" + this.getObject() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericModel)) {
            return false;
        }
        GenericModel other = (GenericModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$object = this.getObject();
        T other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }
}

