/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model;

import de.alpharogroup.model.IChainingModel;
import de.alpharogroup.model.IDetachable;
import de.alpharogroup.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingModel<T>
implements IChainingModel<T> {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOG = LoggerFactory.getLogger(ChainingModel.class);
    private Object target;

    public ChainingModel(Object modelObject) {
        this.target = modelObject;
    }

    @Override
    public void detach() {
        if (this.target instanceof IDetachable) {
            ((IDetachable)this.target).detach();
        }
    }

    @Override
    public void setObject(T object) {
        if (this.target instanceof IModel) {
            ((IModel)this.target).setObject(object);
        } else {
            this.target = object;
        }
    }

    @Override
    public T getObject() {
        if (this.target instanceof IModel) {
            return ((IModel)this.target).getObject();
        }
        return (T)this.target;
    }

    @Override
    public IModel<?> getChainedModel() {
        if (this.target instanceof IModel) {
            return (IModel)this.target;
        }
        return null;
    }

    @Override
    public void setChainedModel(IModel<?> model) {
        this.target = model;
    }

    protected final Object getTarget() {
        return this.target;
    }

    protected final ChainingModel<T> setTarget(Object modelObject) {
        this.target = modelObject;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Model:classname=[");
        sb.append(this.getClass().getName()).append(']');
        sb.append(":nestedModel=[").append(this.target).append(']');
        return sb.toString();
    }
}

