/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model;

import de.alpharogroup.model.ChainingModel;
import de.alpharogroup.model.IModel;
import de.alpharogroup.model.IObjectClassAwareModel;
import de.alpharogroup.model.IPropertyReflectionAwareModel;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPropertyModel<T>
extends ChainingModel<T>
implements IObjectClassAwareModel<T>,
IPropertyReflectionAwareModel<T> {
    private static final long serialVersionUID = 1L;

    public AbstractPropertyModel(Object modelObject) {
        super(modelObject);
    }

    @Override
    public T getObject() {
        String expression = this.propertyExpression();
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return (T)this.getInnermostModelOrObject();
        }
        if (expression.startsWith(".")) {
            throw new IllegalArgumentException("Property expressions cannot start with a '.' character");
        }
        Object target = this.getInnermostModelOrObject();
        if (target != null) {
            try {
                return (T)PropertyUtils.getProperty((Object)target, (String)expression);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public final String getPropertyExpression() {
        return this.propertyExpression();
    }

    @Override
    public void setObject(T object) {
        String expression = this.propertyExpression();
        if (StringUtils.isEmpty((CharSequence)expression)) {
            Object target = this.getTarget();
            if (target instanceof IModel) {
                ((IModel)target).setObject(object);
            } else {
                this.setTarget(object);
            }
        } else {
            Object target = this.getInnermostModelOrObject();
            if (target != null) {
                try {
                    PropertyUtils.setProperty((Object)target, (String)expression, object);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public Class<T> getObjectClass() {
        block8: {
            String expression = this.propertyExpression();
            Object target = this.getInnermostModelOrObject();
            if (StringUtils.isEmpty((CharSequence)expression)) {
                return target != null ? target.getClass() : null;
            }
            if (target != null) {
                try {
                    return PropertyUtils.getPropertyType((Object)target, (String)expression);
                }
                catch (Exception exception) {
                    break block8;
                }
            }
            if (this.getTarget() instanceof IObjectClassAwareModel) {
                try {
                    Class targetClass = ((IObjectClassAwareModel)this.getTarget()).getObjectClass();
                    if (targetClass != null) {
                        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(expression, targetClass);
                        return propertyDescriptor.getPropertyType();
                    }
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public Field getPropertyField() {
        Object target;
        String expression = this.propertyExpression();
        if (!StringUtils.isEmpty((CharSequence)expression) && (target = this.getInnermostModelOrObject()) != null) {
            try {
                return target.getClass().getDeclaredField(expression);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Method getPropertyGetter() {
        Object target;
        String expression = this.propertyExpression();
        if (!StringUtils.isEmpty((CharSequence)expression) && (target = this.getInnermostModelOrObject()) != null) {
            try {
                Class<?> targetClass = target.getClass();
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(expression, targetClass);
                return propertyDescriptor.getReadMethod();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Method getPropertySetter() {
        Object target;
        String expression = this.propertyExpression();
        if (!StringUtils.isEmpty((CharSequence)expression) && (target = this.getInnermostModelOrObject()) != null) {
            try {
                Class<?> targetClass = target.getClass();
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(expression, targetClass);
                return propertyDescriptor.getWriteMethod();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected abstract String propertyExpression();

    public final Object getInnermostModelOrObject() {
        Object tmp;
        Object object = this.getTarget();
        while (object instanceof IModel && (tmp = ((IModel)object).getObject()) != object) {
            object = tmp;
        }
        return object;
    }
}

