/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.net.url;

import de.alpharogroup.net.url.Protocol;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class URLExtensions {
    public static String getFilename(URL url) throws UnsupportedEncodingException {
        if (URLExtensions.isJar(url) || URLExtensions.isEar(url)) {
            String fileName = URLDecoder.decode(url.getFile(), "UTF-8");
            fileName = fileName.substring(5, fileName.indexOf("!"));
            return fileName;
        }
        return URLDecoder.decode(url.getFile(), "UTF-8");
    }

    public static boolean isEar(URL url) {
        return url.getProtocol().equals(Protocol.EAR.getProtocol());
    }

    public static boolean isJar(URL url) {
        return url.getProtocol().equals(Protocol.JAR.getProtocol());
    }

    public static boolean isWar(URL url) {
        return url.getProtocol().equals(Protocol.WAR.getProtocol());
    }
}

