/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.net.throwables;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class ExceptionExtensions {
    public static String getStackTrace(Throwable throwable) throws IOException {
        StringBuilder stacktrace = new StringBuilder();
        if (null == throwable) {
            stacktrace.append("throwable is null...");
            return stacktrace.toString();
        }
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            throwable.printStackTrace(pw);
            stacktrace.append(sw.toString());
        }
        return stacktrace.toString();
    }

    public static String getStackTraceElements(Throwable throwable) throws IOException {
        StringBuilder stacktrace = new StringBuilder();
        if (null == throwable) {
            stacktrace.append("throwable is null...");
            return stacktrace.toString();
        }
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            pw.println(throwable.getClass().toString());
            while (throwable != null) {
                StackTraceElement[] stackTraceElements;
                pw.println(throwable);
                for (StackTraceElement stackTraceElement : stackTraceElements = throwable.getStackTrace()) {
                    pw.println("\tat " + stackTraceElement);
                }
                if ((throwable = throwable.getCause()) == null) continue;
                pw.println("Caused by:\r\n");
            }
            stacktrace.append(sw.toString());
        }
        return stacktrace.toString();
    }

    public static String getStackTraceQueitly(Throwable throwable) {
        StringBuilder stacktrace = new StringBuilder();
        try {
            stacktrace.append(ExceptionExtensions.getStackTrace(throwable));
        }
        catch (IOException e) {
            stacktrace.append("getStackTraceQueitly throwed an IOException:" + e.getMessage());
        }
        return stacktrace.toString();
    }

    private ExceptionExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

