/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.net.socket;

import de.alpharogroup.net.throwables.ExceptionExtensions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketExtensions {
    private static final Logger log = Logger.getLogger(SocketExtensions.class.getName());

    public static boolean available(int port) {
        return SocketExtensions.available("localhost", port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(String host, int port) {
        Socket socket = null;
        try {
            socket = SocketExtensions.newSocket(host, port);
            boolean bl = false;
            return bl;
        }
        catch (IOException ignored) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (!SocketExtensions.closeClientSocket(socket)) {
                log.severe("Socket could not be closed on host " + host + " on port " + port);
            }
        }
    }

    public static void close(Socket clientSocket) throws IOException {
        if (clientSocket != null && !clientSocket.isClosed()) {
            clientSocket.close();
        }
    }

    public static boolean closeClientSocket(Socket clientSocket) {
        boolean closed = true;
        try {
            SocketExtensions.close(clientSocket);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, ExceptionExtensions.getStackTraceQueitly(e));
            closed = false;
        }
        finally {
            try {
                SocketExtensions.close(clientSocket);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, ExceptionExtensions.getStackTraceQueitly(e));
                closed = false;
            }
        }
        return closed;
    }

    public static boolean closeServerSocket(ServerSocket serverSocket) {
        boolean closed = true;
        try {
            if (serverSocket != null && !serverSocket.isClosed()) {
                serverSocket.close();
                serverSocket = null;
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, ExceptionExtensions.getStackTraceQueitly(e));
            closed = false;
        }
        finally {
            try {
                if (serverSocket != null && !serverSocket.isClosed()) {
                    serverSocket.close();
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, ExceptionExtensions.getStackTraceQueitly(e));
                closed = false;
            }
        }
        return closed;
    }

    public static Socket newSocket(String host, int port) throws IOException {
        return new Socket(host, port);
    }

    public static Object readObject(InetAddress inetAddress, int port) throws IOException, ClassNotFoundException {
        return SocketExtensions.readObject(new Socket(inetAddress, port));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object readObject(int port) throws IOException, ClassNotFoundException {
        ServerSocket serverSocket = null;
        Socket clientSocket = null;
        Object objectToReturn = null;
        try {
            serverSocket = new ServerSocket(port);
            clientSocket = serverSocket.accept();
            objectToReturn = SocketExtensions.readObject(clientSocket);
        }
        catch (IOException e) {
            try {
                throw e;
                catch (ClassNotFoundException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                SocketExtensions.closeServerSocket(serverSocket);
                throw throwable;
            }
        }
        SocketExtensions.closeServerSocket(serverSocket);
        return objectToReturn;
    }

    public static Object readObject(Socket clientSocket) throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        Object objectToReturn = null;
        try {
            in = new ObjectInputStream(new BufferedInputStream(clientSocket.getInputStream()));
            while ((objectToReturn = in.readObject()) == null) {
            }
            in.close();
            clientSocket.close();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, ExceptionExtensions.getStackTraceQueitly(e));
            throw e;
        }
        catch (ClassNotFoundException e) {
            log.log(Level.SEVERE, ExceptionExtensions.getStackTraceQueitly(e));
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                SocketExtensions.close(clientSocket);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, ExceptionExtensions.getStackTraceQueitly(e));
                throw e;
            }
        }
        return objectToReturn;
    }

    public static Object readObject(String serverName, int port) throws IOException, ClassNotFoundException {
        InetAddress inetAddress = InetAddress.getByName(serverName);
        return SocketExtensions.readObject(new Socket(inetAddress, port));
    }

    public static void writeObject(InetAddress inetAddress, int port, Object objectToSend) throws IOException {
        Socket socketToClient = null;
        ObjectOutputStream oos = null;
        try {
            socketToClient = new Socket(inetAddress, port);
            oos = new ObjectOutputStream(new BufferedOutputStream(socketToClient.getOutputStream()));
            oos.writeObject(objectToSend);
            oos.close();
            socketToClient.close();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, ExceptionExtensions.getStackTraceQueitly(e));
            throw e;
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                SocketExtensions.close(socketToClient);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, ExceptionExtensions.getStackTraceQueitly(e));
                throw e;
            }
        }
    }

    public static void writeObject(Socket socket, int port, Object objectToSend) throws IOException {
        SocketExtensions.writeObject(socket.getInetAddress(), port, objectToSend);
    }

    public static void writeObject(String serverName, int port, Object objectToSend) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(serverName);
        SocketExtensions.writeObject(inetAddress, port, objectToSend);
    }
}

