/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.net.socket;

import de.alpharogroup.net.throwables.ExceptionExtensions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractClientHandler
implements Runnable {
    private static final Logger log = Logger.getLogger(AbstractClientHandler.class.getName());
    private String clientAddress;
    private InetAddress inetAddressFromClient;
    private Socket socket;

    public AbstractClientHandler(Socket s) {
        this.socket = s;
    }

    protected abstract void process(Object var1);

    @Override
    public void run() {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.clientAddress = this.socket.getInetAddress().getHostAddress();
            this.inetAddressFromClient = this.socket.getInetAddress();
            while (true) {
                Object object = ois.readObject();
                this.process(object);
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, ExceptionExtensions.getStackTraceQueitly(e));
            try {
                if (ois != null) {
                    ois.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e2) {
                log.log(Level.SEVERE, ExceptionExtensions.getStackTraceQueitly(e2));
            }
        }
        catch (ClassNotFoundException cnfe) {
            try {
                log.log(Level.SEVERE, ExceptionExtensions.getStackTraceQueitly(cnfe));
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, ExceptionExtensions.getStackTraceQueitly(e));
                }
            }
        }
        log.info("Socket finished: " + this.socket);
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public InetAddress getInetAddressFromClient() {
        return this.inetAddressFromClient;
    }

    public Socket getSocket() {
        return this.socket;
    }
}

