/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.net.proxy;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;

public class ProxyDecorator
implements Serializable {
    private static final long serialVersionUID = -5551993083532366206L;
    private int failedCount = 0;
    private final Proxy proxy;
    private final Proxy.Type proxyType;
    private final InetSocketAddress socketAddress;

    public ProxyDecorator(Proxy.Type proxyType, InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress == null || proxyType == null) {
            throw new IllegalArgumentException("Arguments can not be null.");
        }
        this.socketAddress = inetSocketAddress;
        this.proxyType = proxyType;
        this.proxy = new Proxy(this.proxyType, this.socketAddress);
    }

    public SocketAddress address() {
        return this.socketAddress;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProxyDecorator other = (ProxyDecorator)obj;
        if (this.failedCount != other.failedCount) {
            return false;
        }
        if (this.proxy == null ? other.proxy != null : !this.proxy.equals(other.proxy)) {
            return false;
        }
        if (this.proxyType != other.proxyType) {
            return false;
        }
        return !(this.socketAddress == null ? other.socketAddress != null : !this.socketAddress.equals(other.socketAddress));
    }

    public int failed() {
        return ++this.failedCount;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.failedCount;
        result = 31 * result + (this.proxy == null ? 0 : this.proxy.hashCode());
        result = 31 * result + (this.proxyType == null ? 0 : this.proxyType.hashCode());
        result = 31 * result + (this.socketAddress == null ? 0 : this.socketAddress.hashCode());
        return result;
    }

    public String toString() {
        return "ProxyDecorator [proxy=" + this.proxy.toString() + ", socketAddress=" + this.socketAddress.toString() + ", proxyType=" + this.proxyType.toString() + ", failedCount=" + this.failedCount + "]";
    }

    public Proxy.Type type() {
        return this.proxyType;
    }
}

