/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.net.proxy;

import de.alpharogroup.net.proxy.ProxyDecorator;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BaseProxySelector
extends ProxySelector {
    private ProxySelector defaultSelector;
    private final Map<SocketAddress, ProxyDecorator> proxies;

    public BaseProxySelector(ProxySelector defaultSelector, Map<SocketAddress, ProxyDecorator> proxies) {
        this.defaultSelector = defaultSelector;
        this.proxies = proxies;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        if (uri == null || sa == null || ioe == null) {
            throw new IllegalArgumentException("Arguments can not be null.");
        }
        ProxyDecorator p = this.proxies.get(sa);
        if (p != null) {
            if (p.failed() >= 3) {
                this.proxies.remove(sa);
            }
        } else if (this.defaultSelector != null) {
            this.defaultSelector.connectFailed(uri, sa, ioe);
        }
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Arguments can not be null.");
        }
        String protocol = uri.getScheme();
        if ("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol)) {
            ArrayList<Proxy> proxyList = new ArrayList<Proxy>();
            for (ProxyDecorator p : this.proxies.values()) {
                proxyList.add(p.getProxy());
            }
            return proxyList;
        }
        if (this.defaultSelector != null) {
            return this.defaultSelector.select(uri);
        }
        ArrayList<Proxy> proxyList = new ArrayList<Proxy>();
        proxyList.add(Proxy.NO_PROXY);
        return proxyList;
    }
}

