/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.net.socket;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.log4j.Logger;

public abstract class AbstractClientHandler
implements Runnable {
    private static Logger logger = Logger.getLogger((String)AbstractClientHandler.class.getName());
    private InetAddress inetAddressFromClient = null;
    private String clientAddress = null;
    private Socket socket = null;

    public AbstractClientHandler(Socket s) {
        this.socket = s;
    }

    protected abstract void process(Object var1);

    @Override
    public void run() {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.clientAddress = this.socket.getInetAddress().getHostAddress();
            this.inetAddressFromClient = this.socket.getInetAddress();
            while (true) {
                Object object = ois.readObject();
                this.process(object);
            }
        }
        catch (IOException e) {
            System.out.println("IO Fehler bei socket: " + e.toString());
            logger.error((Object)("IO Fehler bei socket: " + e.toString()), (Throwable)e);
            try {
                if (ois != null) {
                    ois.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e2) {
                logger.error((Object)("IO Fehler bei socket: " + e2.toString()), (Throwable)e2);
            }
        }
        catch (ClassNotFoundException cnfe) {
            try {
                logger.error((Object)("Eine ClassNotFoundException wurde erzeugt:\n " + cnfe.getMessage()), (Throwable)cnfe);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("IO Fehler bei socket: " + e.toString()), (Throwable)e);
                }
            }
        }
        logger.info((Object)("Socket Beended: " + this.socket));
    }

    public InetAddress getInetAddressFromClient() {
        return this.inetAddressFromClient;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public Socket getSocket() {
        return this.socket;
    }
}

