/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.crypto.sha;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import net.sourceforge.jaulp.crypto.aes.HexEncryptor;
import net.sourceforge.jaulp.crypto.algorithm.HashAlgorithm;
import net.sourceforge.jaulp.random.RandomUtils;
import org.apache.commons.codec.binary.Base64;

public class Hasher {
    public static String hash(String hashIt, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm.getAlgorithm());
        messageDigest.reset();
        messageDigest.update(salt.getBytes(charset));
        return new String(messageDigest.digest(hashIt.getBytes(charset)), charset);
    }

    public static String hashAndHex(String hashIt, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        HexEncryptor hexEncryptor = new HexEncryptor();
        return hexEncryptor.encrypt(Hasher.hash(hashIt, salt, hashAlgorithm, charset));
    }

    public static String hashAndBase64(String hashIt, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException {
        String hashedAndBase64 = new Base64().encodeToString(Hasher.hash(hashIt, salt, hashAlgorithm, charset).getBytes(charset));
        return hashedAndBase64;
    }

    public static byte[] getRandomSalt(int length, Charset charset) {
        return RandomUtils.getRandomString((String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789", (int)length).getBytes(charset);
    }
}

