/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.crypto.aes;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import net.sourceforge.jaulp.crypto.algorithm.Algorithm;
import net.sourceforge.jaulp.crypto.interfaces.Encryptor;
import org.apache.commons.codec.binary.Hex;

public class HexEncryptor
implements Encryptor {
    private Cipher cipher = null;
    private String privateKey = null;
    private Algorithm algorithm = Algorithm.AES;
    private boolean initialized;

    public HexEncryptor(String privateKey) {
        this.setPrivateKey(privateKey);
    }

    public HexEncryptor(String privateKey, Algorithm algorithm) {
        this.setPrivateKey(privateKey);
        this.algorithm = algorithm;
    }

    @Override
    public String encrypt(String string) throws InvalidKeyException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        this.initialize();
        byte[] utf8 = string.getBytes("UTF-8");
        byte[] encrypt = this.cipher.doFinal(utf8);
        char[] original = Hex.encodeHex((byte[])encrypt, (boolean)false);
        return new String(original);
    }

    private void initialize() throws UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        if (!this.isInitialized()) {
            byte[] key = this.getPrivateKey() != null ? this.getPrivateKey().getBytes("UTF-8") : "privattop secret".getBytes("UTF-8");
            SecretKeySpec skeySpec = new SecretKeySpec(key, this.algorithm.getAlgorithm());
            this.cipher = Cipher.getInstance(this.algorithm.getAlgorithm());
            this.cipher.init(1, skeySpec);
        }
    }

    public HexEncryptor() {
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public void setCipher(Cipher cipher) {
        this.cipher = cipher;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    private boolean isInitialized() {
        return this.initialized;
    }
}

