/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.crypto.aes;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import net.sourceforge.jaulp.crypto.aes.HexDump;
import net.sourceforge.jaulp.crypto.algorithm.Algorithm;
import net.sourceforge.jaulp.crypto.interfaces.Decryptor;
import org.apache.commons.codec.DecoderException;

public class HexDecryptor
implements Decryptor {
    private Cipher cipher = null;
    private String privateKey = null;
    private boolean initialized;

    public HexDecryptor(String privateKey) {
        this.setPrivateKey(privateKey);
    }

    @Override
    public String decrypt(String encypted) throws InvalidKeyException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, DecoderException, IllegalBlockSizeException, BadPaddingException {
        this.initialize();
        byte[] dec = HexDump.decodeHex(encypted.toCharArray());
        byte[] utf8 = this.cipher.doFinal(dec);
        return new String(utf8, "UTF-8");
    }

    private void initialize() throws UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        if (!this.isInitialized()) {
            byte[] key = this.getPrivateKey() != null ? this.getPrivateKey().getBytes("UTF-8") : "privattop secret".getBytes("UTF-8");
            SecretKeySpec skeySpec = new SecretKeySpec(key, Algorithm.AES.getAlgorithm());
            this.cipher = Cipher.getInstance(Algorithm.AES.getAlgorithm());
            this.cipher.init(2, skeySpec);
        }
    }

    public HexDecryptor() {
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public void setCipher(Cipher cipher) {
        this.cipher = cipher;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    private boolean isInitialized() {
        return this.initialized;
    }
}

