/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.crypto;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import net.sourceforge.jaulp.crypto.algorithm.HashAlgorithm;
import net.sourceforge.jaulp.crypto.sha.Hasher;
import net.sourceforge.jaulp.random.RandomObjectsUtils;

public class PasswordEncryptor
implements Serializable {
    private static final long serialVersionUID = -4667877106378932018L;
    private final HashAlgorithm DEFAULT_ALGORITHM = HashAlgorithm.SHA_512;
    private final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final PasswordEncryptor instance = new PasswordEncryptor();

    public static PasswordEncryptor getInstance() {
        return instance;
    }

    private PasswordEncryptor() {
    }

    public String getRandomPassword(int length) {
        return RandomObjectsUtils.getRandomPassword((int)length);
    }

    public String getRandomSalt(int length) {
        return new String(Hasher.getRandomSalt(length, this.DEFAULT_CHARSET), this.DEFAULT_CHARSET);
    }

    public String hashAndHexPassword(String password, String salt) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        return this.hashAndHexPassword(password, salt, this.DEFAULT_ALGORITHM, this.DEFAULT_CHARSET);
    }

    public String hashAndHexPassword(String password, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        String hashedPassword = Hasher.hashAndHex(password, salt, hashAlgorithm, charset);
        return hashedPassword;
    }

    public String hashPassword(String password, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException {
        String hashedPassword = Hasher.hash(password, salt, hashAlgorithm, charset);
        return hashedPassword;
    }

    public boolean match(String hashedPassword, String dbHashedPassword) {
        return hashedPassword.equals(dbHashedPassword);
    }
}

