/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model.reflect;

import de.alpharogroup.model.reflect.IProxyFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.List;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public final class DefaultProxyFactory
implements IProxyFactory {
    private final NamingPolicy NAMING_POLICY = new DefaultNamingPolicy(){

        protected String getTag() {
            return "LAZY";
        }
    };
    private final Objenesis objenesis = new ObjenesisStd();

    @Override
    public Class<?> createClass(Class<?> clazz) {
        Class[] interfaces;
        if (clazz.isInterface()) {
            interfaces = new Class[]{clazz};
            clazz = Object.class;
        } else if (Proxy.isProxyClass(clazz)) {
            interfaces = clazz.getInterfaces();
            clazz = Object.class;
        } else if (Factory.class.isAssignableFrom(clazz)) {
            interfaces = null;
            clazz = clazz.getSuperclass();
        } else {
            interfaces = null;
        }
        if (Modifier.isFinal(clazz.getModifiers())) {
            return null;
        }
        Enhancer enhancer = new Enhancer(){

            protected void filterConstructors(Class sc, List constructors) {
            }
        };
        enhancer.setUseFactory(true);
        enhancer.setSuperclass(clazz);
        enhancer.setInterfaces(interfaces);
        enhancer.setNamingPolicy(this.NAMING_POLICY);
        enhancer.setCallbackTypes(new Class[]{MethodInterceptor.class});
        return enhancer.createClass();
    }

    @Override
    public Object createInstance(Class<?> proxyClass, IProxyFactory.Callback callback) {
        Factory proxy = (Factory)this.objenesis.newInstance(proxyClass);
        proxy.setCallback(0, (Callback)new MethodInterceptorImplementation(callback));
        return proxy;
    }

    @Override
    public IProxyFactory.Callback getCallback(Object proxy) {
        if (proxy instanceof Factory) {
            MethodInterceptorImplementation interceptor = (MethodInterceptorImplementation)((Factory)proxy).getCallback(0);
            return interceptor.callback;
        }
        return null;
    }

    private final class MethodInterceptorImplementation
    implements MethodInterceptor {
        public final IProxyFactory.Callback callback;

        private MethodInterceptorImplementation(IProxyFactory.Callback callback) {
            this.callback = callback;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            return this.callback.on(obj, method, args);
        }
    }
}

