/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model.typesafe;

import de.alpharogroup.model.LoadableDetachableModel;
import de.alpharogroup.model.api.ChainableModel;
import de.alpharogroup.model.api.Detachable;
import de.alpharogroup.model.api.Model;
import de.alpharogroup.model.api.ObjectClassAware;
import de.alpharogroup.model.api.ObjectTypeAware;
import de.alpharogroup.model.api.PropertyReflectionAwareModel;
import de.alpharogroup.model.reflect.CachingMethodResolver;
import de.alpharogroup.model.reflect.DefaultMethodResolver;
import de.alpharogroup.model.reflect.Evaluation;
import de.alpharogroup.model.reflect.IMethodResolver;
import de.alpharogroup.model.reflect.Reflection;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;

public class TypeSafeModel<T>
implements Model<T>,
ObjectClassAware<T>,
ObjectTypeAware<T>,
PropertyReflectionAwareModel<T> {
    private static final Object[] EMPTY_ARGS = new Object[0];
    public static IMethodResolver methodResolver = new CachingMethodResolver(new DefaultMethodResolver());
    private static final long serialVersionUID = 1L;
    protected final Object stack;
    protected final Object target;

    public static <T> T from(Class<T> targetType) {
        if (targetType == null) {
            throw new RuntimeException("target type must not be null");
        }
        Evaluation evaluation = new Evaluation(targetType);
        return (T)evaluation.proxy();
    }

    public static <T> T from(Model<T> target) {
        if (target == null) {
            throw new RuntimeException("target must not be null");
        }
        Type type = TypeSafeModel.getType(target);
        if (type == null) {
            throw new RuntimeException("cannot detect target type");
        }
        BoundEvaluation evaluation = new BoundEvaluation(type, target);
        return (T)evaluation.proxy();
    }

    public static <T> T from(Model<T> target, Class<T> type) {
        return (T)new BoundEvaluation(type, target).proxy();
    }

    public static <T> T from(T target) {
        if (target == null) {
            throw new RuntimeException("target must not be null");
        }
        BoundEvaluation evaluation = new BoundEvaluation(target.getClass(), target);
        return (T)evaluation.proxy();
    }

    private static Type getType(Model<?> model) {
        Type type = null;
        if (model instanceof ObjectTypeAware) {
            type = ((ObjectTypeAware)model).getObjectType();
        } else if (model instanceof ObjectClassAware) {
            type = ((ObjectClassAware)model).getObjectClass();
        }
        if (type == null) {
            try {
                type = model.getClass().getMethod("getObject", new Class[0]).getGenericReturnType();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (type instanceof TypeVariable) {
                type = Reflection.resultType(model.getClass(), type);
            }
        }
        return type;
    }

    private static <R> TypeSafeModel<R> model(Evaluation<R> evaluation) {
        Object[] stack;
        Object target = null;
        if (evaluation instanceof BoundEvaluation) {
            target = ((BoundEvaluation)evaluation).target;
        }
        if (evaluation.stack.size() == 0) {
            stack = null;
        } else if (evaluation.stack.size() == 1) {
            stack = methodResolver.getId((Method)evaluation.stack.get(0));
        } else {
            Object[] array = new Object[evaluation.stack.size()];
            int index = 0;
            while (index < array.length) {
                Method method = (Method)evaluation.stack.get(index);
                array[index] = methodResolver.getId(method);
                ++index;
                for (int p = 0; p < method.getParameterTypes().length; ++p) {
                    TypeSafeModel<Object> param = evaluation.stack.get(index);
                    if (param instanceof Evaluation) {
                        param = TypeSafeModel.model(param);
                    }
                    array[index] = param;
                    ++index;
                }
            }
            stack = array;
        }
        return new TypeSafeModel(target, stack);
    }

    public static <R> TypeSafeModel<R> model(R result) {
        return TypeSafeModel.model(Evaluation.eval(result));
    }

    public static <R> String path(R result) {
        Method method;
        Evaluation<R> evaluation = Evaluation.eval(result);
        StringBuilder path = new StringBuilder();
        for (int index = 0; index < evaluation.stack.size(); index += 1 + method.getParameterTypes().length) {
            if (path.length() > 0) {
                path.append(".");
            }
            method = (Method)evaluation.stack.get(index);
            path.append(methodResolver.getId(method));
        }
        return path.toString();
    }

    TypeSafeModel(Object target, Object stack) {
        this.target = target;
        this.stack = stack;
    }

    public void attach() {
    }

    public TypeSafeModel<T> bind(Object target) {
        return new TypeSafeModel<T>(target, this.stack);
    }

    private void checkBound() {
        if (this.target == null) {
            throw new RuntimeException("not bound to a target");
        }
    }

    public void detach() {
        if (this.target instanceof Detachable) {
            ((Detachable)this.target).detach();
        }
        if (this.stack instanceof Detachable) {
            ((Detachable)this.stack).detach();
        }
        if (this.stack instanceof Object[]) {
            for (Object object : (Object[])this.stack) {
                if (!(object instanceof Detachable)) continue;
                ((Detachable)object).detach();
            }
        }
    }

    public T getObject() {
        this.checkBound();
        Object result = this.target;
        if (result instanceof Model) {
            result = ((Model)result).getObject();
        }
        MethodIterator methodIterator = new MethodIterator();
        while (result != null && methodIterator.hasNext()) {
            methodIterator.next(result.getClass());
            result = methodIterator.get(result);
        }
        return (T)result;
    }

    public Class<T> getObjectClass() {
        Type type = this.getObjectType();
        if (type == null) {
            return null;
        }
        return Reflection.getClass(type);
    }

    public Type getObjectType() {
        if (this.target == null) {
            return null;
        }
        Type type = this.getTargetType();
        if (type != null) {
            MethodIterator methodIterator = new MethodIterator();
            while (methodIterator.hasNext()) {
                methodIterator.next(Reflection.getClass(type));
                if ((type = Reflection.resultType(type, methodIterator.method.getGenericReturnType())) != null) continue;
                break;
            }
        }
        return type;
    }

    public String getPath() {
        this.checkBound();
        StringBuilder string = new StringBuilder();
        Type type = this.getTargetType();
        if (type == null) {
            throw new RuntimeException("cannot detect target type");
        }
        MethodIterator methodIterator = new MethodIterator();
        while (methodIterator.hasNext()) {
            methodIterator.next(Reflection.getClass(type));
            if (string.length() > 0) {
                string.append(".");
            }
            string.append(methodIterator.id.toString());
            type = Reflection.resultType(type, methodIterator.method.getGenericReturnType());
        }
        return string.toString();
    }

    public Field getPropertyField() {
        return null;
    }

    public Method getPropertyGetter() {
        this.checkBound();
        Type type = this.getTargetType();
        if (type != null) {
            MethodIterator methodIterator = new MethodIterator();
            while (methodIterator.hasNext()) {
                methodIterator.next(Reflection.getClass(type));
                if ((type = Reflection.resultType(type, methodIterator.method.getGenericReturnType())) != null) continue;
                return null;
            }
            if (Reflection.isGetter(methodIterator.method)) {
                return methodIterator.method;
            }
        }
        return null;
    }

    public Method getPropertySetter() {
        this.checkBound();
        Method getter = this.getPropertyGetter();
        if (getter == null) {
            return null;
        }
        return methodResolver.getSetter(getter);
    }

    public Object getTarget() {
        return this.target;
    }

    private Type getTargetType() {
        Type type = null;
        if (this.target instanceof Model) {
            Object object;
            type = TypeSafeModel.getType((Model)this.target);
            if (type instanceof TypeVariable) {
                type = null;
            }
            if ((type == null || type instanceof Class) && (object = ((Model)this.target).getObject()) != null) {
                type = object.getClass();
            }
        } else {
            type = this.target.getClass();
        }
        return type;
    }

    public Model<T> loadableDetachable() {
        return new LoadableDetachableWrapper();
    }

    public void setObject(T result) {
        this.checkBound();
        Object target = this.target;
        MethodIterator methodIterator = new MethodIterator();
        if (!methodIterator.hasNext()) {
            if (target instanceof Model) {
                ((Model)target).setObject(result);
                return;
            }
            throw new UnsupportedOperationException();
        }
        if (target instanceof Model) {
            target = ((Model)target).getObject();
        }
        if (target == null) {
            throw new RuntimeException("no target");
        }
        methodIterator.next(target.getClass());
        while (target != null && methodIterator.hasNext()) {
            target = methodIterator.get(target);
            methodIterator.next(target.getClass());
        }
        methodIterator.set(target, result);
    }

    public String toString() {
        if (this.target != null) {
            try {
                return this.getPath();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return "";
    }

    private class MethodIterator {
        private int count = 0;
        private Serializable id;
        private int index = 0;
        private Method method;

        private MethodIterator() {
        }

        private void fillArguments(Object[] args) {
            for (int a = 0; a < this.count; ++a) {
                Object arg = ((Object[])TypeSafeModel.this.stack)[this.index - this.count + a];
                if (arg instanceof TypeSafeModel) {
                    arg = ((TypeSafeModel)arg).getObject();
                }
                args[a] = arg;
            }
        }

        public Object get(Object target) {
            Object[] args;
            if (this.count == 0) {
                args = EMPTY_ARGS;
            } else {
                args = new Object[this.count];
                this.fillArguments(args);
            }
            try {
                if (target instanceof List && Reflection.isListIndex(this.method) && ((List)target).size() <= (Integer)args[0]) {
                    return null;
                }
                return this.method.invoke(target, args);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean hasNext() {
            if (TypeSafeModel.this.stack instanceof Object[]) {
                return this.index < ((Object[])TypeSafeModel.this.stack).length;
            }
            return TypeSafeModel.this.stack != null && this.index == 0;
        }

        public void next(Class<?> clazz) {
            this.id = TypeSafeModel.this.stack instanceof Object[] ? (Serializable)((Object[])TypeSafeModel.this.stack)[this.index] : (Serializable)TypeSafeModel.this.stack;
            ++this.index;
            this.method = methodResolver.getMethod(clazz, this.id);
            this.count = this.method.getParameterTypes().length;
            this.index += this.count;
        }

        public void set(Object target, Object result) {
            Method setter = methodResolver.getSetter(this.method);
            Object[] args = new Object[this.count + 1];
            this.fillArguments(args);
            args[this.count] = result;
            try {
                setter.invoke(target, args);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private class LoadableDetachableWrapper
    extends LoadableDetachableModel<T>
    implements ObjectClassAware<T>,
    ObjectTypeAware<T>,
    ChainableModel<T> {
        private static final long serialVersionUID = 1L;
        private transient Type type;

        private LoadableDetachableWrapper() {
        }

        public void attach() {
        }

        public void detach() {
            super.detach();
            this.type = null;
            TypeSafeModel.this.detach();
        }

        public Model<?> getChainedModel() {
            return TypeSafeModel.this;
        }

        public Class<T> getObjectClass() {
            Type type = this.getObjectType();
            if (type == null) {
                return null;
            }
            return Reflection.getClass(type);
        }

        public Type getObjectType() {
            if (this.type == null) {
                this.type = TypeSafeModel.this.getObjectType();
            }
            return this.type;
        }

        protected T load() {
            return TypeSafeModel.this.getObject();
        }

        public void setChainedModel(Model<?> model) {
            throw new UnsupportedOperationException();
        }

        public void setObject(T object) {
            super.setObject(object);
            TypeSafeModel.this.setObject(object);
        }
    }

    private static class BoundEvaluation<R>
    extends Evaluation<R> {
        public final Object target;

        public BoundEvaluation(Type type, Object target) {
            super(type);
            this.target = target;
        }
    }
}

