/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;

public final class Objects {
    private static final int BIGDEC = 9;
    private static final int BIGINT = 6;
    private static final int BOOL = 0;
    private static final int BYTE = 1;
    private static final int CHAR = 2;
    private static final int DOUBLE = 8;
    private static final int FLOAT = 7;
    private static final int INT = 4;
    private static final int LONG = 5;
    private static final int MIN_REAL_TYPE = 7;
    private static final int NONNUMERIC = 10;
    private static final int SHORT = 3;
    private static final HashMap<Class<?>, Object> primitiveDefaults = new HashMap();

    public static BigDecimal bigDecValue(Object value) throws NumberFormatException {
        if (value == null) {
            return BigDecimal.valueOf(0L);
        }
        Class<?> c = value.getClass();
        if (c == BigDecimal.class) {
            return (BigDecimal)value;
        }
        if (c == BigInteger.class) {
            return new BigDecimal((BigInteger)value);
        }
        if (c.getSuperclass() == Number.class) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        if (c == Boolean.class) {
            return BigDecimal.valueOf((Boolean)value != false ? 1L : 0L);
        }
        if (c == Character.class) {
            return BigDecimal.valueOf(((Character)value).charValue());
        }
        return new BigDecimal(Objects.stringValue(value, true));
    }

    public static BigInteger bigIntValue(Object value) throws NumberFormatException {
        if (value == null) {
            return BigInteger.valueOf(0L);
        }
        Class<?> c = value.getClass();
        if (c == BigInteger.class) {
            return (BigInteger)value;
        }
        if (c == BigDecimal.class) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (c.getSuperclass() == Number.class) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (c == Boolean.class) {
            return BigInteger.valueOf((Boolean)value != false ? 1L : 0L);
        }
        if (c == Character.class) {
            return BigInteger.valueOf(((Character)value).charValue());
        }
        return new BigInteger(Objects.stringValue(value, true));
    }

    public static boolean booleanValue(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> c = value.getClass();
        if (c == Boolean.class) {
            return (Boolean)value;
        }
        if (c == Character.class) {
            return ((Character)value).charValue() != '\u0000';
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        return true;
    }

    public static int compareWithConversion(Object v1, Object v2) {
        int result;
        if (v1 == v2) {
            result = 0;
        } else {
            int t1 = Objects.getNumericType(v1);
            int t2 = Objects.getNumericType(v2);
            int type = Objects.getNumericType(t1, t2, true);
            switch (type) {
                case 6: {
                    result = Objects.bigIntValue(v1).compareTo(Objects.bigIntValue(v2));
                    break;
                }
                case 9: {
                    result = Objects.bigDecValue(v1).compareTo(Objects.bigDecValue(v2));
                    break;
                }
                case 10: {
                    if (t1 == 10 && t2 == 10) {
                        if (v1 instanceof Comparable && v1.getClass().isAssignableFrom(v2.getClass())) {
                            result = ((Comparable)v1).compareTo(v2);
                            break;
                        }
                        throw new IllegalArgumentException("invalid comparison: " + v1.getClass().getName() + " and " + v2.getClass().getName());
                    }
                }
                case 7: 
                case 8: {
                    double dv1 = Objects.doubleValue(v1);
                    double dv2 = Objects.doubleValue(v2);
                    return dv1 == dv2 ? 0 : (dv1 < dv2 ? -1 : 1);
                }
                default: {
                    long lv1 = Objects.longValue(v1);
                    long lv2 = Objects.longValue(v2);
                    return lv1 == lv2 ? 0 : (lv1 < lv2 ? -1 : 1);
                }
            }
        }
        return result;
    }

    public static <T> T convertValue(Object value, Class<T> toType) {
        Object result = null;
        if (value != null) {
            if (value.getClass().isArray() && toType.isArray()) {
                Class<?> componentType = toType.getComponentType();
                result = Array.newInstance(componentType, Array.getLength(value));
                int icount = Array.getLength(value);
                for (int i = 0; i < icount; ++i) {
                    Array.set(result, i, Objects.convertValue(Array.get(value, i), componentType));
                }
            } else {
                if (toType == Integer.class || toType == Integer.TYPE) {
                    result = (int)Objects.longValue(value);
                }
                if (toType == Double.class || toType == Double.TYPE) {
                    result = Objects.doubleValue(value);
                }
                if (toType == Boolean.class || toType == Boolean.TYPE) {
                    Object object = result = Objects.booleanValue(value) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (toType == Byte.class || toType == Byte.TYPE) {
                    result = (byte)Objects.longValue(value);
                }
                if (toType == Character.class || toType == Character.TYPE) {
                    result = Character.valueOf((char)Objects.longValue(value));
                }
                if (toType == Short.class || toType == Short.TYPE) {
                    result = (short)Objects.longValue(value);
                }
                if (toType == Long.class || toType == Long.TYPE) {
                    result = Objects.longValue(value);
                }
                if (toType == Float.class || toType == Float.TYPE) {
                    result = new Float(Objects.doubleValue(value));
                }
                if (toType == BigInteger.class) {
                    result = Objects.bigIntValue(value);
                }
                if (toType == BigDecimal.class) {
                    result = Objects.bigDecValue(value);
                }
                if (toType == String.class) {
                    result = Objects.stringValue(value);
                }
            }
        } else if (toType.isPrimitive()) {
            result = primitiveDefaults.get(toType);
        }
        Object finalResult = result;
        return (T)finalResult;
    }

    public static <T> T defaultIfNull(T originalObj, T defaultObj) {
        return originalObj != null ? originalObj : defaultObj;
    }

    public static double doubleValue(Object value) throws NumberFormatException {
        if (value == null) {
            return 0.0;
        }
        Class<?> c = value.getClass();
        if (c.getSuperclass() == Number.class) {
            return ((Number)value).doubleValue();
        }
        if (c == Boolean.class) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (c == Character.class) {
            return ((Character)value).charValue();
        }
        String s = Objects.stringValue(value, true);
        return s.length() == 0 ? 0.0 : Double.parseDouble(s);
    }

    public static boolean equal(Object a, Object b) {
        if (a == b) {
            return true;
        }
        return a != null && b != null && a.equals(b);
    }

    public static int getNumericType(int t1, int t2, boolean canBeNonNumeric) {
        if (t1 == t2) {
            return t1;
        }
        if (canBeNonNumeric && (t1 == 10 || t2 == 10 || t1 == 2 || t2 == 2)) {
            return 10;
        }
        if (t1 == 10) {
            t1 = 8;
        }
        if (t2 == 10) {
            t2 = 8;
        }
        if (t1 >= 7) {
            if (t2 >= 7) {
                return Math.max(t1, t2);
            }
            if (t2 < 4) {
                return t1;
            }
            if (t2 == 6) {
                return 9;
            }
            return Math.max(8, t1);
        }
        if (t2 >= 7) {
            if (t1 < 4) {
                return t2;
            }
            if (t1 == 6) {
                return 9;
            }
            return Math.max(8, t2);
        }
        return Math.max(t1, t2);
    }

    public static int getNumericType(Object value) {
        if (value != null) {
            Class<?> c = value.getClass();
            if (c == Integer.class) {
                return 4;
            }
            if (c == Double.class) {
                return 8;
            }
            if (c == Boolean.class) {
                return 0;
            }
            if (c == Byte.class) {
                return 1;
            }
            if (c == Character.class) {
                return 2;
            }
            if (c == Short.class) {
                return 3;
            }
            if (c == Long.class) {
                return 5;
            }
            if (c == Float.class) {
                return 7;
            }
            if (c == BigInteger.class) {
                return 6;
            }
            if (c == BigDecimal.class) {
                return 9;
            }
        }
        return 10;
    }

    public static int getNumericType(Object v1, Object v2) {
        return Objects.getNumericType(v1, v2, false);
    }

    public static int getNumericType(Object v1, Object v2, boolean canBeNonNumeric) {
        return Objects.getNumericType(Objects.getNumericType(v1), Objects.getNumericType(v2), canBeNonNumeric);
    }

    public static int hashCode(Object ... obj) {
        if (obj == null || obj.length == 0) {
            return 0;
        }
        int result = 37;
        for (int i = obj.length - 1; i > -1; --i) {
            result = 37 * result + (obj[i] != null ? obj[i].hashCode() : 0);
        }
        return result;
    }

    public static boolean isEqual(Object object1, Object object2) {
        boolean result = false;
        if (object1 == object2) {
            result = true;
        } else if (object1 != null && object1.getClass().isArray()) {
            if (object2 != null && object2.getClass().isArray() && object2.getClass() == object1.getClass()) {
                boolean bl = result = Array.getLength(object1) == Array.getLength(object2);
                if (result) {
                    int icount = Array.getLength(object1);
                    for (int i = 0; result && i < icount; ++i) {
                        result = Objects.isEqual(Array.get(object1, i), Array.get(object2, i));
                    }
                }
            }
        } else {
            result = object1 != null && object2 != null && (Objects.compareWithConversion(object1, object2) == 0 || object1.equals(object2));
        }
        return result;
    }

    public static long longValue(Object value) throws NumberFormatException {
        if (value == null) {
            return 0L;
        }
        Class<?> c = value.getClass();
        if (c.getSuperclass() == Number.class) {
            return ((Number)value).longValue();
        }
        if (c == Boolean.class) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (c == Character.class) {
            return ((Character)value).charValue();
        }
        return Long.parseLong(Objects.stringValue(value, true));
    }

    public static Number newInteger(int type, long value) {
        switch (type) {
            case 0: 
            case 2: 
            case 4: {
                return (int)value;
            }
            case 7: {
                return Float.valueOf(value);
            }
            case 8: {
                return (double)value;
            }
            case 5: {
                return value;
            }
            case 1: {
                return (byte)value;
            }
            case 3: {
                return (short)value;
            }
        }
        return BigInteger.valueOf(value);
    }

    public static String stringValue(Object value) {
        return Objects.stringValue(value, false);
    }

    public static String stringValue(Object value, boolean trim) {
        String result;
        if (value == null) {
            result = "null";
        } else {
            result = value.toString();
            if (trim) {
                result = result.trim();
            }
        }
        return result;
    }

    private Objects() {
    }

    static {
        primitiveDefaults.put(Boolean.TYPE, Boolean.FALSE);
        primitiveDefaults.put(Byte.TYPE, (byte)0);
        primitiveDefaults.put(Short.TYPE, (short)0);
        primitiveDefaults.put(Character.TYPE, Character.valueOf('\u0000'));
        primitiveDefaults.put(Integer.TYPE, 0);
        primitiveDefaults.put(Long.TYPE, 0L);
        primitiveDefaults.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveDefaults.put(Double.TYPE, 0.0);
        primitiveDefaults.put(BigInteger.class, new BigInteger("0"));
        primitiveDefaults.put(BigDecimal.class, new BigDecimal(0.0));
    }
}

