/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model.reflect;

import de.alpharogroup.model.reflect.CachingProxyFactory;
import de.alpharogroup.model.reflect.DefaultProxyFactory;
import de.alpharogroup.model.reflect.IProxyFactory;
import de.alpharogroup.model.reflect.Reflection;
import de.alpharogroup.model.util.Objects;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Evaluation<R>
implements IProxyFactory.Callback {
    private static final Logger log = LoggerFactory.getLogger(Evaluation.class);
    private static final ThreadLocal<Evaluation<?>> lastNonProxyable = new ThreadLocal();
    public static IProxyFactory proxyFactory = new CachingProxyFactory(new DefaultProxyFactory());
    public final List<Object> stack = new ArrayList<Object>();
    private Type type;

    public static <R> Evaluation<R> eval(R result) {
        Evaluation<?> evaluation = (Evaluation<?>)proxyFactory.getCallback(result);
        if (evaluation == null) {
            evaluation = lastNonProxyable.get();
            lastNonProxyable.remove();
            if (evaluation == null) {
                throw new RuntimeException("no invocation result given");
            }
        }
        return evaluation;
    }

    public static <T> T of(Class<T> type) {
        return (T)new Evaluation(type).proxy();
    }

    public Evaluation(Type type) {
        this.type = type;
    }

    @Override
    public Object on(Object obj, Method method, Object[] parameters) throws Throwable {
        if ("finalize".equals(method.getName())) {
            super.finalize();
            return null;
        }
        this.stack.add(method);
        for (Object param : parameters) {
            Evaluation<?> evaluation;
            if (param == null && (evaluation = lastNonProxyable.get()) != null) {
                lastNonProxyable.remove();
                this.stack.add(evaluation);
                continue;
            }
            this.stack.add(param);
        }
        this.type = Reflection.resultType(this.type, method.getGenericReturnType());
        if (this.type == null) {
            log.debug("falling back to raw type for method {}", (Object)method);
            this.type = method.getReturnType();
        }
        return this.proxy();
    }

    public Object proxy() {
        Class<?> clazz = Reflection.getClass(this.type);
        if (clazz.isPrimitive()) {
            lastNonProxyable.set(this);
            return Objects.convertValue(null, clazz);
        }
        Class<?> proxyClass = proxyFactory.createClass(clazz);
        if (proxyClass == null) {
            lastNonProxyable.set(this);
            return null;
        }
        return proxyFactory.createInstance(proxyClass, this);
    }
}

