/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model.reflect;

import de.alpharogroup.model.reflect.IProxyFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CachingProxyFactory
implements IProxyFactory {
    private final ConcurrentHashMap<Object, IProxyFactory> scopes = new ConcurrentHashMap(2);
    private final IProxyFactory factory;

    public CachingProxyFactory(IProxyFactory factory) {
        this.factory = factory;
    }

    @Override
    public Class<?> createClass(Class<?> clazz) {
        return this.getFactory().createClass(clazz);
    }

    @Override
    public Object createInstance(Class<?> proxyClass, IProxyFactory.Callback callback) {
        return this.getFactory().createInstance(proxyClass, callback);
    }

    public void destroy(Object application) {
        this.scopes.remove(application);
    }

    @Override
    public IProxyFactory.Callback getCallback(Object proxy) {
        return this.getFactory().getCallback(proxy);
    }

    private IProxyFactory getFactory() {
        IProxyFactory tmpResult;
        Class<CachingProxyFactory> key = CachingProxyFactory.class;
        IProxyFactory result = this.scopes.get(key);
        if (result == null && (tmpResult = this.scopes.putIfAbsent(key, result = new ApplicationScope())) != null) {
            result = tmpResult;
        }
        return result;
    }

    private class NOT_PROXYABLE {
        private NOT_PROXYABLE() {
        }
    }

    private class ApplicationScope
    implements IProxyFactory {
        private final Map<Class<?>, Class<?>> proxyClasses = new ConcurrentHashMap();

        private ApplicationScope() {
        }

        @Override
        public Class<?> createClass(Class<?> clazz) {
            Class<Object> proxyClazz = this.proxyClasses.get(clazz);
            if (proxyClazz == null) {
                proxyClazz = CachingProxyFactory.this.factory.createClass(clazz);
                if (proxyClazz == null) {
                    proxyClazz = NOT_PROXYABLE.class;
                }
                this.proxyClasses.put(clazz, proxyClazz);
            }
            if (proxyClazz == NOT_PROXYABLE.class) {
                proxyClazz = null;
            }
            return proxyClazz;
        }

        @Override
        public Object createInstance(Class<?> proxyClass, IProxyFactory.Callback callback) {
            return CachingProxyFactory.this.factory.createInstance(proxyClass, callback);
        }

        @Override
        public IProxyFactory.Callback getCallback(Object proxy) {
            return CachingProxyFactory.this.factory.getCallback(proxy);
        }
    }
}

