/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model.property;

import de.alpharogroup.model.property.AbstractGetAndSet;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MethodGetAndSet
extends AbstractGetAndSet {
    private static final Logger log = LoggerFactory.getLogger(MethodGetAndSet.class);
    private final Method getMethod;
    private final Method setMethod;
    private final Field field;

    public static final Method findSetter(Method getMethod, Class<?> clz) {
        String name = getMethod.getName();
        name = name.startsWith("get") ? "set" + name.substring(3) : "set" + name.substring(2);
        try {
            Method method = clz.getMethod(name, getMethod.getReturnType());
            if (method != null) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            Method[] methods;
            for (Method method : methods = clz.getMethods()) {
                Class<?>[] parameterTypes;
                if (!method.getName().equals(name) || (parameterTypes = method.getParameterTypes()).length != 1 || !parameterTypes[0].isAssignableFrom(getMethod.getReturnType())) continue;
                return method;
            }
            log.debug("Cannot find setter corresponding to " + getMethod);
        }
        catch (Exception e) {
            log.debug("Cannot find setter corresponding to " + getMethod);
        }
        return null;
    }

    MethodGetAndSet(Method getMethod, Method setMethod, Field field) {
        this.getMethod = getMethod;
        this.getMethod.setAccessible(true);
        this.field = field;
        this.setMethod = setMethod;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Method getGetter() {
        return this.getMethod;
    }

    @Override
    public Method getSetter() {
        return this.setMethod;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.getMethod.getReturnType();
    }

    public final Object getValue(Object object) {
        Object ret = null;
        try {
            ret = this.getMethod.invoke(object, (Object[])null);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Error calling method: " + this.getMethod + " on object: " + object, ex.getCause());
        }
        catch (Exception ex) {
            throw new RuntimeException("Error calling method: " + this.getMethod + " on object: " + object, ex);
        }
        return ret;
    }

    public Object newValue(Object object) {
        if (this.setMethod == null) {
            log.warn("Null setMethod");
            return null;
        }
        Class<?> clz = this.getMethod.getReturnType();
        Object value = null;
        try {
            value = clz.newInstance();
            this.setMethod.invoke(object, value);
        }
        catch (Exception e) {
            log.warn("Cannot set new value " + value, (Throwable)e);
        }
        return value;
    }

    public final void setValue(Object object, Object value) {
        Object converted = value;
        if (this.setMethod != null) {
            try {
                this.setMethod.invoke(object, converted);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException("Error calling method: " + this.setMethod + " on object: " + object, ex.getCause());
            }
            catch (Exception ex) {
                throw new RuntimeException("Error calling method: " + this.setMethod + " on object: " + object, ex);
            }
        } else if (this.field != null) {
            try {
                this.field.set(object, converted);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error setting field: " + this.field + " on object: " + object, ex);
            }
        } else {
            throw new RuntimeException("no set method defined for value: " + value + " on object: " + object + " while respective getMethod being " + this.getMethod.getName());
        }
    }
}

