/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model.property;

import de.alpharogroup.model.property.AbstractGetAndSet;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldGetAndSetter
extends AbstractGetAndSet {
    private static final Logger log = LoggerFactory.getLogger(FieldGetAndSetter.class);
    private final Field field;

    public FieldGetAndSetter(Field field) {
        this.field = field;
        this.field.setAccessible(true);
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.field.getType();
    }

    public Object getValue(Object object) {
        try {
            return this.field.get(object);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error getting field value of field " + this.field + " from object " + object, ex);
        }
    }

    public Object newValue(Object object) {
        Class<?> clz = this.field.getType();
        Object value = null;
        try {
            value = clz.newInstance();
            this.field.set(object, value);
        }
        catch (Exception e) {
            log.warn("Cannot set field " + this.field + " to " + value, (Throwable)e);
        }
        return value;
    }

    public void setValue(Object object, Object value) {
        try {
            this.field.set(object, value);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error setting field value of field " + this.field + " on object " + object + ", value " + value, ex);
        }
    }
}

