/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model.property;

import de.alpharogroup.model.property.AbstractGetAndSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArrayPropertyGetSet
extends AbstractGetAndSet {
    private static final Logger log = LoggerFactory.getLogger(ArrayPropertyGetSet.class);
    private final Integer index;
    private final Method getMethod;
    private Method setMethod;

    private static final Method findSetter(Method getMethod, Class<?> clz) {
        String name = getMethod.getName();
        name = "set" + name.substring(3);
        try {
            return clz.getMethod(name, Integer.TYPE, getMethod.getReturnType());
        }
        catch (Exception e) {
            log.debug("Can't find setter method corresponding to " + getMethod);
            return null;
        }
    }

    ArrayPropertyGetSet(Method method, int index) {
        this.index = index;
        this.getMethod = method;
        this.getMethod.setAccessible(true);
    }

    @Override
    public Class<?> getTargetClass() {
        return this.getMethod.getReturnType();
    }

    public Object getValue(Object object) {
        Object ret = null;
        try {
            ret = this.getMethod.invoke(object, this.index);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Error calling index property method: " + this.getMethod + " on object: " + object, ex.getCause());
        }
        catch (Exception ex) {
            throw new RuntimeException("Error calling index property method: " + this.getMethod + " on object: " + object, ex);
        }
        return ret;
    }

    public Object newValue(Object object) {
        if (this.setMethod == null) {
            this.setMethod = ArrayPropertyGetSet.findSetter(this.getMethod, object.getClass());
        }
        if (this.setMethod == null) {
            log.warn("Null setMethod");
            return null;
        }
        Class<?> clz = this.getMethod.getReturnType();
        Object value = null;
        try {
            value = clz.newInstance();
            this.setMethod.invoke(object, this.index, value);
        }
        catch (Exception e) {
            log.warn("Cannot set new value " + value + " at index " + this.index, (Throwable)e);
        }
        return value;
    }

    public void setValue(Object object, Object value) {
        if (this.setMethod == null) {
            this.setMethod = ArrayPropertyGetSet.findSetter(this.getMethod, object.getClass());
        }
        if (this.setMethod != null) {
            this.setMethod.setAccessible(true);
            try {
                this.setMethod.invoke(object, this.index, value);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException("Error index property calling method: " + this.setMethod + " on object: " + object, ex.getCause());
            }
            catch (Exception ex) {
                throw new RuntimeException("Error index property calling method: " + this.setMethod + " on object: " + object, ex);
            }
        } else {
            throw new RuntimeException("No set method defined for value: " + value + " on object: " + object);
        }
    }
}

