/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model.property;

import de.alpharogroup.model.property.AbstractGetAndSet;
import java.lang.reflect.Array;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArrayGetSet
extends AbstractGetAndSet {
    private static final Logger log = LoggerFactory.getLogger(ArrayGetSet.class);
    private final int index;
    private final Class<?> clzComponentType;

    ArrayGetSet(Class<?> clzComponentType, int index) {
        this.clzComponentType = clzComponentType;
        this.index = index;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.clzComponentType;
    }

    public Object getValue(Object object) {
        if (Array.getLength(object) > this.index) {
            return Array.get(object, this.index);
        }
        return null;
    }

    public Object newValue(Object object) {
        Object value = null;
        try {
            value = this.clzComponentType.newInstance();
            Array.set(object, this.index, value);
        }
        catch (Exception e) {
            log.warn("Cannot set new value " + value + " at index " + this.index + " for array holding elements of class " + this.clzComponentType, (Throwable)e);
        }
        return value;
    }

    public void setValue(Object object, Object value) {
        Array.set(object, this.index, value);
    }
}

