/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model;

import de.alpharogroup.model.api.Model;

public abstract class LoadableDetachableModel<T>
implements Model<T> {
    private static final long serialVersionUID = 1L;
    private transient boolean attached = false;
    private transient T transientModelObject;

    public LoadableDetachableModel(T object) {
        this.transientModelObject = object;
        this.attached = true;
    }

    public void detach() {
        if (this.attached) {
            try {
                this.onDetach();
            }
            finally {
                this.attached = false;
                this.transientModelObject = null;
            }
        }
    }

    public final T getObject() {
        if (!this.attached) {
            this.attached = true;
            this.transientModelObject = this.load();
            this.onAttach();
        }
        return this.transientModelObject;
    }

    public final boolean isAttached() {
        return this.attached;
    }

    protected abstract T load();

    protected void onAttach() {
    }

    protected void onDetach() {
    }

    public void setObject(T object) {
        this.attached = true;
        this.transientModelObject = object;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(":attached=").append(this.attached).append(":tempModelObject=[").append(this.transientModelObject).append("]");
        return sb.toString();
    }

    public LoadableDetachableModel() {
    }
}

