/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model;

import de.alpharogroup.model.api.Attachable;
import de.alpharogroup.model.api.Detachable;
import de.alpharogroup.model.api.Model;
import de.alpharogroup.model.api.ObjectClassAware;
import de.alpharogroup.model.util.MapModel;
import de.alpharogroup.model.util.WildcardCollectionModel;
import de.alpharogroup.model.util.WildcardListModel;
import de.alpharogroup.model.util.WildcardSetModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GenericModel<T>
implements Model<T>,
ObjectClassAware<T> {
    private static final long serialVersionUID = 1L;
    private T object;

    public static <C> Model<Collection<C>> ofCollection(Collection<C> collection) {
        return new WildcardCollectionModel<C>(collection);
    }

    public static <C> Model<List<C>> ofList(List<C> list) {
        return WildcardListModel.of(list);
    }

    public static <K, V> Model<Map<K, V>> ofMap(Map<K, V> map) {
        return MapModel.ofMap(map);
    }

    public static <C> Model<Set<C>> ofSet(Set<C> set) {
        return WildcardSetModel.ofSet(set);
    }

    public GenericModel(T object) {
        this.setObject(object);
    }

    public void attach() {
        if (this.object instanceof Attachable) {
            ((Attachable)this.object).attach();
        }
    }

    public void detach() {
        if (this.object instanceof Detachable) {
            ((Detachable)this.object).detach();
        }
    }

    public Class<T> getObjectClass() {
        return this.object != null ? this.object.getClass() : null;
    }

    public T getObject() {
        return this.object;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public String toString() {
        return "GenericModel(object=" + this.getObject() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericModel)) {
            return false;
        }
        GenericModel other = (GenericModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$object = this.getObject();
        T other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    public GenericModel() {
    }
}

