/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model;

import de.alpharogroup.model.api.Attachable;
import de.alpharogroup.model.api.ChainableModel;
import de.alpharogroup.model.api.Detachable;
import de.alpharogroup.model.api.Model;

public class ChainingModel<T>
implements ChainableModel<T> {
    private static final long serialVersionUID = 1L;
    private Object target;

    public ChainingModel(Object target) {
        this.target = target;
    }

    public void attach() {
        if (this.target instanceof Attachable) {
            ((Attachable)this.target).attach();
        }
    }

    public void detach() {
        if (this.target instanceof Detachable) {
            ((Detachable)this.target).detach();
        }
    }

    public Model<?> getChainedModel() {
        if (this.target instanceof Model) {
            return (Model)this.target;
        }
        return null;
    }

    public T getObject() {
        if (this.target instanceof Model) {
            return (T)((Model)this.target).getObject();
        }
        return (T)this.target;
    }

    protected final Object getTarget() {
        return this.target;
    }

    public void setChainedModel(Model<?> model) {
        this.target = model;
    }

    public void setObject(T object) {
        if (this.target instanceof Model) {
            ((Model)this.target).setObject(object);
        } else {
            this.target = object;
        }
    }

    protected final ChainingModel<T> setTarget(Object modelObject) {
        this.target = modelObject;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Model:classname=[");
        sb.append(this.getClass().getName()).append(']');
        sb.append(":nestedModel=[").append(this.target).append(']');
        return sb.toString();
    }
}

